/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.location;

import com.plotsquared.core.util.StringMan;

public class BlockLoc {
    public static final BlockLoc ZERO = new BlockLoc(0, 0, 0);
    public static final BlockLoc MINY = new BlockLoc(0, Integer.MIN_VALUE, 0);
    private static final BlockLoc MIDDLE = new BlockLoc(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final int x;
    private final int y;
    private final int z;
    private final float yaw;
    private final float pitch;

    public BlockLoc(int n, int n2, int n3) {
        this(n, n2, n3, 0.0f, 0.0f);
    }

    public BlockLoc(int n, int n2, int n3, float f, float f2) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.yaw = f;
        this.pitch = f2;
    }

    public static BlockLoc fromString(String string) {
        float f;
        float f2;
        if (string == null || "side".equalsIgnoreCase(string)) {
            return null;
        }
        if (StringMan.isEqualIgnoreCaseToAny(string, "center", "middle", "centre")) {
            return MIDDLE;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length == 5) {
            f2 = Float.parseFloat(stringArray[3]);
            f = Float.parseFloat(stringArray[4]);
        } else if (stringArray.length == 3) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            return ZERO;
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        return new BlockLoc(n, n2, n3, f2, f);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + this.getX();
        n2 = n * n2 + this.getY();
        n2 = n * n2 + this.getZ();
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return this.getX() == 0 && this.getY() == 0 && this.getZ() == 0;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BlockLoc blockLoc = (BlockLoc)object;
        return this.getX() == blockLoc.getX() && this.getY() == blockLoc.getY() && this.getZ() == blockLoc.getZ() && this.getYaw() == blockLoc.getYaw() && this.getPitch() == blockLoc.getPitch();
    }

    public String toString() {
        if (this.getX() == 0 && this.getY() == 0 && this.getZ() == 0 && this.getYaw() == 0.0f && this.getPitch() == 0.0f) {
            return "";
        }
        return this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getYaw() + "," + this.getPitch();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }
}

