/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.location;

public enum Direction {
    ALL(-1, "all"),
    NORTH(0, "north"),
    EAST(1, "east"),
    SOUTH(2, "south"),
    WEST(3, "west"),
    NORTHEAST(4, "northeast"),
    SOUTHEAST(5, "southeast"),
    SOUTHWEST(6, "southwest"),
    NORTHWEST(7, "northwest");

    private final int index;
    private final String name;

    private Direction(int n2, String string2) {
        this.index = n2;
        this.name = string2;
    }

    public static Direction getFromIndex(int n) {
        for (Direction direction : Direction.values()) {
            if (direction.getIndex() != n) continue;
            return direction;
        }
        return NORTH;
    }

    public Direction opposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ALL -> ALL;
            case NORTH -> SOUTH;
            case EAST -> WEST;
            case SOUTH -> NORTH;
            case WEST -> EAST;
            case NORTHEAST -> SOUTHWEST;
            case SOUTHEAST -> NORTHWEST;
            case SOUTHWEST -> NORTHEAST;
            case NORTHWEST -> SOUTHEAST;
        };
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }
}

