/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.paster;

import com.google.common.base.Charsets;
import com.google.gson.JsonParser;
import com.plotsquared.core.annotation.Nonnull;
import com.plotsquared.core.annotation.Nullable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class IncendoPaster {
    public static final String UPLOAD_PATH = "https://athion.net/ISPaster/paste/upload";
    public static final Collection<String> VALID_APPLICATIONS = Arrays.asList("plotsquared", "fastasyncworldedit", "incendopermissions", "kvantum");
    private final Collection<PasteFile> files = new ArrayList<PasteFile>();
    private final String pasteApplication;

    public IncendoPaster(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("paste application cannot be null, nor empty");
        }
        if (!VALID_APPLICATIONS.contains(string.toLowerCase(Locale.ROOT))) {
            throw new IllegalArgumentException(String.format("Unknown application name: %s", string));
        }
        this.pasteApplication = string;
    }

    public static String debugPaste(@Nonnull File file, @Nullable String string, File ... fileArray) {
        return IncendoPaster.debugPaste(file, string, fileArray == null ? null : Arrays.asList(fileArray));
    }

    public static String debugPaste(@Nonnull File file, @Nullable String string, @Nullable List<File> list) {
        File file22;
        Object object;
        IncendoPaster incendoPaster = new IncendoPaster("fastasyncworldedit");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# Welcome to this paste\n# It is meant to provide us at IntellectualSites with better information about your problem\n");
        stringBuilder.append("\n# Server Information\n");
        stringBuilder.append(string);
        stringBuilder.append("\n# YAY! Now, let's see what we can find in your JVM\n");
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        stringBuilder.append("Uptime: ").append(TimeUnit.MINUTES.convert(runtimeMXBean.getUptime(), TimeUnit.MILLISECONDS)).append(" minutes").append('\n');
        stringBuilder.append("JVM Flags: ").append(runtimeMXBean.getInputArguments()).append('\n');
        stringBuilder.append("Free Memory: ").append(runtime.freeMemory() / 1024L / 1024L).append(" MB").append('\n');
        stringBuilder.append("Max Memory: ").append(runtime.maxMemory() / 1024L / 1024L).append(" MB").append('\n');
        stringBuilder.append("Total Memory: ").append(runtime.totalMemory() / 1024L / 1024L).append(" MB").append('\n');
        stringBuilder.append("Available Processors: ").append(runtime.availableProcessors()).append('\n');
        stringBuilder.append("Java Name: ").append(runtimeMXBean.getVmName()).append('\n');
        stringBuilder.append("Java Version: '").append(System.getProperty("java.version")).append("'\n");
        stringBuilder.append("Java Vendor: '").append(System.getProperty("java.vendor")).append("'\n");
        stringBuilder.append("Operating System: '").append(System.getProperty("os.name")).append("'\n");
        stringBuilder.append("OS Version: ").append(System.getProperty("os.version")).append('\n');
        stringBuilder.append("OS Arch: ").append(System.getProperty("os.arch")).append('\n');
        stringBuilder.append("# Okay :D Great. The paste has been created successfully.");
        incendoPaster.addFile(new PasteFile("information", stringBuilder.toString()));
        try {
            object = Files.size(file.toPath()) > 14000000L ? "latest.log is larger than 14 MB. Not uploading." : IncendoPaster.readFile(file, true);
            incendoPaster.addFile(new PasteFile("latest.log", (String)object));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (list != null) {
            for (File file22 : list) {
                incendoPaster.addFile(file22);
            }
        }
        try {
            object = incendoPaster.upload();
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to upload files: %s", throwable.getMessage()), throwable);
        }
        file22 = new JsonParser().parse((String)object).getAsJsonObject();
        if (file22.has("created")) {
            String string2 = file22.get("paste_id").getAsString();
            return String.format("https://athion.net/ISPaster/paste/view/%s", string2);
        }
        throw new IOException(String.format("Failed to upload files: %s", file22.get("response").getAsString()));
    }

    private static String readFile(File file, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
        }
        for (int i = Math.max(0, arrayList.size() - 1000); i < arrayList.size(); ++i) {
            stringBuilder.append((String)arrayList.get(i)).append("\n");
        }
        String string = stringBuilder.toString();
        if (bl) {
            string = string.replaceAll("\\b(1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\\.(1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\\.(1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\\.(1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\\b", "*");
        }
        return string;
    }

    public final Collection<PasteFile> getFiles() {
        return Collections.unmodifiableCollection(this.files);
    }

    public void addFile(File file) {
        this.addFile(file, null);
    }

    public void addFile(File file, @Nullable String string) {
        String string2 = string != null ? string : file.getName();
        boolean bl = string2.endsWith(".log") || string2.endsWith(".txt") || !string2.contains(".");
        this.addFile(new PasteFile(string2, IncendoPaster.readFile(file, bl)));
    }

    public void addFile(PasteFile pasteFile) {
        if (pasteFile == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        for (PasteFile pasteFile2 : this.files) {
            if (!pasteFile2.fileName.equalsIgnoreCase(pasteFile.getFileName())) continue;
            throw new IllegalArgumentException(String.format("Found duplicate file with name %s", pasteFile.getFileName()));
        }
        this.files.add(pasteFile);
    }

    private String toJsonString() {
        PasteFile pasteFile;
        StringBuilder stringBuilder = new StringBuilder("{\n");
        stringBuilder.append("\"paste_application\": \"").append(this.pasteApplication).append("\",\n\"files\": \"");
        Iterator<PasteFile> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            pasteFile = iterator.next();
            stringBuilder.append(pasteFile.getFileName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("\",\n");
        iterator = this.files.iterator();
        while (iterator.hasNext()) {
            pasteFile = iterator.next();
            stringBuilder.append("\"file-").append(pasteFile.getFileName()).append("\": \"").append(pasteFile.getContent().replaceAll("\"", "\\\\\"")).append("\"");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",\n");
        }
        stringBuilder.append("\n}");
        return stringBuilder.toString();
    }

    public final String upload() {
        URL uRL = new URL(UPLOAD_PATH);
        URLConnection uRLConnection = uRL.openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        byte[] byArray = this.toJsonString().getBytes(Charsets.UTF_8);
        httpURLConnection.setFixedLengthStreamingMode(byArray.length);
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.connect();
        try (Object object = httpURLConnection.getOutputStream();){
            ((OutputStream)object).write(byArray);
        }
        if (!httpURLConnection.getResponseMessage().contains("OK")) {
            throw new IllegalStateException(String.format("Server returned status: %d %s", httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage()));
        }
        object = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                ((StringBuilder)object).append(string).append("\n");
            }
        }
        return ((StringBuilder)object).toString();
    }

    public static class PasteFile {
        private final String fileName;
        private final String content;

        public PasteFile(String string, String string2) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("file name cannot be null, nor empty");
            }
            if (string2 == null || string2.isEmpty()) {
                throw new IllegalArgumentException("content cannot be null, nor empty");
            }
            this.fileName = string;
            this.content = string2;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getContent() {
            return this.content;
        }
    }
}

