/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.player;

import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.synchronization.LockRepository;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class MetaDataAccess<T>
implements AutoCloseable {
    private final PlotPlayer<?> player;
    private final MetaDataKey<T> metaDataKey;
    private final LockRepository.LockAccess lockAccess;
    private boolean closed = false;

    MetaDataAccess(@NonNull PlotPlayer<?> plotPlayer, @NonNull MetaDataKey<T> metaDataKey,  @NonNull LockRepository.LockAccess lockAccess) {
        this.player = plotPlayer;
        this.metaDataKey = metaDataKey;
        this.lockAccess = lockAccess;
    }

    private static <E extends Throwable> void sneakyThrow(Throwable throwable) {
        throw throwable;
    }

    public abstract boolean isPresent();

    public abstract @Nullable T remove();

    public abstract void set(@NonNull T var1);

    public abstract @NonNull Optional<T> get();

    @Override
    public final void close() {
        this.lockAccess.close();
        this.closed = true;
    }

    public @NonNull PlotPlayer<?> getPlayer() {
        return this.player;
    }

    public @NonNull MetaDataKey<T> getMetaDataKey() {
        return this.metaDataKey;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void checkClosed() {
        if (this.closed) {
            MetaDataAccess.sneakyThrow(new IllegalAccessException("The meta data access instance has been closed"));
        }
    }
}

