/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.player;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.plotsquared.core.synchronization.LockKey;
import com.plotsquared.google.TypeLiteral;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MetaDataKey<T> {
    private static final Map<String, MetaDataKey<?>> keyMap = new HashMap();
    private static final Object keyMetaData = new Object();
    private final String key;
    private final TypeLiteral<T> type;
    private final LockKey lockKey;

    private MetaDataKey(@NonNull String string, @NonNull TypeLiteral<T> typeLiteral) {
        this.key = (String)Preconditions.checkNotNull((Object)string, (Object)"Key may not be null");
        this.type = (TypeLiteral)Preconditions.checkNotNull(typeLiteral, (Object)"Type may not be null");
        this.lockKey = LockKey.of(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> @NonNull MetaDataKey<T> of(@NonNull String string2, @NonNull TypeLiteral<T> typeLiteral) {
        Object object = keyMetaData;
        synchronized (object) {
            return keyMap.computeIfAbsent(string2, string -> new MetaDataKey((String)string, typeLiteral));
        }
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MetaDataKey metaDataKey = (MetaDataKey)object;
        return Objects.equal((Object)this.key, (Object)metaDataKey.key);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key});
    }

    public @NonNull LockKey getLockKey() {
        return this.lockKey;
    }

    public @NonNull TypeLiteral<T> getType() {
        return this.type;
    }
}

