/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.player;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.collection.ByteArrayUtilities;
import com.plotsquared.core.command.CommandCaller;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.audience.Audience;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.adventure.title.Title;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionMap;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.NullPermissionProfile;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.permissions.PermissionProfile;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PersistentMetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.TemporaryMetaDataAccess;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotWeather;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.synchronization.LockRepository;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.item.ItemType;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PlotPlayer<P>
implements CommandCaller,
OfflinePlotPlayer,
LocaleHolder {
    private static final String NON_EXISTENT_CAPTION = "<red>PlotSquared does not recognize the caption: ";
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotPlayer.class.getSimpleName()));
    private static final Set<PlotPlayer<?>> debugModeEnabled = Collections.synchronizedSet(new HashSet());
    private static final Map<Class<?>, PlotPlayerConverter> converters = new HashMap();
    private final LockRepository lockRepository = new LockRepository();
    private final PlotAreaManager plotAreaManager;
    private final EventDispatcher eventDispatcher;
    private final PermissionHandler permissionHandler;
    private Map<String, byte[]> metaMap = new HashMap<String, byte[]>();
    private ConcurrentHashMap<String, Object> meta;
    private int hash;
    private Locale locale;
    private PermissionProfile permissionProfile;

    public PlotPlayer(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull PermissionHandler permissionHandler) {
        this.plotAreaManager = plotAreaManager;
        this.eventDispatcher = eventDispatcher;
        this.permissionHandler = permissionHandler;
    }

    public static <T> PlotPlayer<T> from(@NonNull T t) {
        Class clazz;
        if (converters.containsKey(t.getClass())) {
            return converters.get(t.getClass()).convert(t);
        }
        ArrayDeque arrayDeque = new ArrayDeque();
        arrayDeque.add(t.getClass());
        while ((clazz = (Class)arrayDeque.poll()) != null) {
            PlotPlayerConverter plotPlayerConverter = converters.get(clazz);
            if (plotPlayerConverter != null) {
                if (clazz != t.getClass()) {
                    converters.put(t.getClass(), plotPlayerConverter);
                    LOGGER.info("Registered {} as with converter for {}", t.getClass(), (Object)clazz);
                }
                return plotPlayerConverter.convert(t);
            }
            if (clazz.getSuperclass() != null) {
                arrayDeque.add(clazz.getSuperclass());
            }
            arrayDeque.addAll(Arrays.asList(clazz.getInterfaces()));
        }
        throw new IllegalArgumentException(String.format("There is no registered PlotPlayer converter for type %s", t.getClass().getSimpleName()));
    }

    public static <T> void registerConverter(@NonNull Class<T> clazz, PlotPlayerConverter<T> plotPlayerConverter) {
        converters.put(clazz, plotPlayerConverter);
    }

    public static Collection<PlotPlayer<?>> getDebugModePlayers() {
        return Collections.unmodifiableCollection(debugModeEnabled);
    }

    public static Collection<PlotPlayer<?>> getDebugModePlayersInPlot(@NonNull Plot plot) {
        if (debugModeEnabled.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList linkedList = new LinkedList();
        for (PlotPlayer<?> plotPlayer : debugModeEnabled) {
            if (!plotPlayer.getCurrentPlot().equals(plot)) continue;
            linkedList.add(plotPlayer);
        }
        return linkedList;
    }

    protected void setupPermissionProfile() {
        this.permissionProfile = this.permissionHandler.getPermissionProfile(this).orElse(NullPermissionProfile.INSTANCE);
    }

    @Override
    public final boolean hasPermission(@Nullable String string, @NonNull String string2) {
        return this.permissionProfile.hasPermission(string, string2);
    }

    @Override
    public final boolean hasKeyedPermission(@Nullable String string, @NonNull String string2, @NonNull String string3) {
        return this.permissionProfile.hasKeyedPermission(string, string2, string3);
    }

    @Override
    public final boolean hasPermission(@NonNull String string, boolean bl) {
        if (!this.hasPermission(string)) {
            if (bl) {
                this.sendMessage((Caption)TranslatableCaption.of("permission.no_permission_event"), TagResolver.resolver("node", Tag.inserting(Component.text(string))));
            }
            return false;
        }
        return true;
    }

    public abstract Actor toActor();

    public abstract P getPlatformPlayer();

    void setMeta(String string, Object object) {
        if (object == null) {
            this.deleteMeta(string);
        } else {
            if (this.meta == null) {
                this.meta = new ConcurrentHashMap();
            }
            this.meta.put(string, object);
        }
    }

    <T> T getMeta(String string) {
        if (this.meta != null) {
            return (T)this.meta.get(string);
        }
        return null;
    }

    <T> T getMeta(String string, T t) {
        T t2 = this.getMeta(string);
        if (t2 == null) {
            return t;
        }
        return t2;
    }

    public ConcurrentHashMap<String, Object> getMeta() {
        return this.meta;
    }

    Object deleteMeta(String string) {
        return this.meta == null ? null : this.meta.remove(string);
    }

    public String toString() {
        return this.getName();
    }

    public Plot getCurrentPlot() {
        try (MetaDataAccess<Plot> metaDataAccess = this.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
            if (metaDataAccess.get().orElse(null) == null && !Settings.Enabled_Components.EVENTS) {
                Plot plot = this.getLocation().getPlot();
                return plot;
            }
            Plot plot = metaDataAccess.get().orElse(null);
            return plot;
        }
    }

    public int getAllowedPlots() {
        return this.hasPermissionRange("plots.plot", Settings.Limit.MAX_PLOTS);
    }

    public int getPlotCount() {
        if (!Settings.Limit.GLOBAL) {
            return this.getPlotCount(this.getLocation().getWorldName());
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        UUID uUID = this.getUUID();
        this.plotAreaManager.forEachPlotArea(plotArea -> {
            if (!Settings.Done.COUNTS_TOWARDS_LIMIT) {
                for (Plot plot : plotArea.getPlotsAbs(uUID)) {
                    if (DoneFlag.isDone(plot)) continue;
                    atomicInteger.incrementAndGet();
                }
            } else {
                atomicInteger.addAndGet(plotArea.getPlotsAbs(uUID).size());
            }
        });
        return atomicInteger.get();
    }

    public int getClusterCount() {
        if (!Settings.Limit.GLOBAL) {
            return this.getClusterCount(this.getLocation().getWorldName());
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        this.plotAreaManager.forEachPlotArea(plotArea -> {
            for (PlotCluster plotCluster : plotArea.getClusters()) {
                if (!plotCluster.isOwner(this.getUUID())) continue;
                atomicInteger.incrementAndGet();
            }
        });
        return atomicInteger.get();
    }

    public int getPlotCount(String string) {
        UUID uUID = this.getUUID();
        int n = 0;
        for (PlotArea plotArea : this.plotAreaManager.getPlotAreasSet(string)) {
            if (!Settings.Done.COUNTS_TOWARDS_LIMIT) {
                n = (int)((long)n + plotArea.getPlotsAbs(uUID).stream().filter(plot -> !DoneFlag.isDone(plot)).count());
                continue;
            }
            n += plotArea.getPlotsAbs(uUID).size();
        }
        return n;
    }

    public int getClusterCount(String string) {
        int n = 0;
        for (PlotArea plotArea : this.plotAreaManager.getPlotAreasSet(string)) {
            for (PlotCluster plotCluster : plotArea.getClusters()) {
                if (!plotCluster.isOwner(this.getUUID())) continue;
                ++n;
            }
        }
        return n;
    }

    public Set<Plot> getPlots() {
        return PlotQuery.newQuery().ownedBy(this).asSet();
    }

    public @Nullable PlotArea getPlotAreaAbs() {
        return this.plotAreaManager.getPlotArea(this.getLocation());
    }

    public PlotArea getApplicablePlotArea() {
        return this.plotAreaManager.getApplicablePlotArea(this.getLocation());
    }

    @Override
    public @NonNull RequiredType getSuperCaller() {
        return RequiredType.PLAYER;
    }

    public @NonNull Location getLocation() {
        Location location = (Location)this.getMeta("location");
        if (location != null) {
            return location;
        }
        return this.getLocationFull();
    }

    public abstract Location getLocationFull();

    @Override
    public abstract @NonNull UUID getUUID();

    public boolean canTeleport(@NonNull Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"Specified location cannot be null");
        Location location2 = this.getLocationFull();
        this.teleport(location);
        boolean bl = this.getLocation().equals(location);
        this.teleport(location2);
        return bl;
    }

    public void teleport(Location location) {
        this.teleport(location, TeleportCause.PLUGIN);
    }

    public abstract void teleport(Location var1, TeleportCause var2);

    public void plotkick(Location location) {
        this.setMeta("kick", true);
        this.teleport(location, TeleportCause.KICK);
        this.deleteMeta("kick");
    }

    public abstract void setCompassTarget(Location var1);

    public void setAttribute(String string) {
        this.setPersistentMeta("attrib_" + string, new byte[]{1});
    }

    public boolean getAttribute(String string) {
        if (!this.hasPersistentMeta("attrib_" + string)) {
            return false;
        }
        return this.getPersistentMeta("attrib_" + string)[0] == 1;
    }

    public void removeAttribute(String string) {
        this.removePersistentMeta("attrib_" + string);
    }

    public abstract void setWeather(@NonNull PlotWeather var1);

    public abstract @NonNull GameMode getGameMode();

    public abstract void setGameMode(@NonNull GameMode var1);

    public abstract void setTime(long var1);

    public abstract boolean getFlight();

    public abstract void setFlight(boolean var1);

    public abstract void playMusic(@NonNull Location var1, @NonNull ItemType var2);

    public abstract boolean isBanned();

    public abstract void kick(String var1);

    public void refreshDebug() {
        boolean bl = this.getAttribute("debug");
        if (bl && !debugModeEnabled.contains(this)) {
            debugModeEnabled.add(this);
        } else if (!bl) {
            debugModeEnabled.remove(this);
        }
    }

    public void unregister() {
        Plot plot = this.getCurrentPlot();
        if (plot != null && Settings.Enabled_Components.PERSISTENT_META && plot.getArea() instanceof SinglePlotArea) {
            PlotId plotId = plot.getId();
            int n = plotId.getX();
            int n2 = plotId.getY();
            ByteBuffer byteBuffer = ByteBuffer.allocate(13);
            byteBuffer.putShort((short)n);
            byteBuffer.putShort((short)n2);
            Location location = this.getLocation();
            byteBuffer.putInt(location.getX());
            byteBuffer.put((byte)location.getY());
            byteBuffer.putInt(location.getZ());
            this.setPersistentMeta("quitLoc", byteBuffer.array());
        } else if (this.hasPersistentMeta("quitLoc")) {
            this.removePersistentMeta("quitLoc");
        }
        if (plot != null) {
            this.eventDispatcher.callLeave(this, plot);
        }
        if (Settings.Enabled_Components.BAN_DELETER && this.isBanned()) {
            for (Plot plot2 : this.getPlots()) {
                plot2.getPlotModificationManager().deletePlot(null, null);
                LOGGER.info("Plot {} was deleted + cleared due to {} getting banned", (Object)plot2.getId(), (Object)this.getName());
            }
        }
        if (PlotSquared.platform().expireManager() != null) {
            PlotSquared.platform().expireManager().storeDate(this.getUUID(), System.currentTimeMillis());
        }
        PlotSquared.platform().playerManager().removePlayer(this);
        PlotSquared.platform().unregister(this);
        debugModeEnabled.remove(this);
    }

    public int getPlayerClusterCount(String string) {
        return PlotSquared.get().getClusters(string).stream().filter(plotCluster -> this.getUUID().equals(plotCluster.owner)).mapToInt(PlotCluster::getArea).sum();
    }

    public int getPlayerClusterCount() {
        AtomicInteger atomicInteger = new AtomicInteger();
        this.plotAreaManager.forEachPlotArea(plotArea -> atomicInteger.addAndGet(plotArea.getClusters().size()));
        return atomicInteger.get();
    }

    public Set<Plot> getPlots(String string) {
        return PlotQuery.newQuery().inWorld(string).ownedBy(this.getUUID()).asSet();
    }

    public void populatePersistentMetaMap() {
        if (Settings.Enabled_Components.PERSISTENT_META) {
            DBFunc.getPersistentMeta(this.getUUID(), new RunnableVal<Map<String, byte[]>>(){

                @Override
                public void run(Map<String, byte[]> map) {
                    try {
                        PlotPlayer.this.metaMap = map;
                        if (map.isEmpty()) {
                            return;
                        }
                        if (PlotPlayer.this.getAttribute("debug")) {
                            debugModeEnabled.add(PlotPlayer.this);
                        }
                        if (!Settings.Teleport.ON_LOGIN) {
                            return;
                        }
                        PlotAreaManager plotAreaManager = PlotPlayer.this.plotAreaManager;
                        if (!(plotAreaManager instanceof SinglePlotAreaManager)) {
                            return;
                        }
                        SinglePlotArea singlePlotArea = ((SinglePlotAreaManager)plotAreaManager).getArea();
                        byte[] byArray = PlotPlayer.this.getPersistentMeta("quitLoc");
                        if (byArray == null) {
                            return;
                        }
                        PlotPlayer.this.removePersistentMeta("quitLoc");
                        if (!PlotPlayer.this.getMeta("teleportOnLogin", true).booleanValue()) {
                            return;
                        }
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                        short s = byteBuffer.getShort();
                        short s2 = byteBuffer.getShort();
                        PlotId plotId = PlotId.of(s, s2);
                        int n = byteBuffer.getInt();
                        int n2 = byteBuffer.get() & 0xFF;
                        int n3 = byteBuffer.getInt();
                        Plot plot = singlePlotArea.getOwnedPlot(plotId);
                        if (plot == null) {
                            return;
                        }
                        Location location = Location.at(plot.getWorldName(), n, n2, n3);
                        if (plot.isLoaded()) {
                            TaskManager.runTask(() -> {
                                if (PlotPlayer.this.getMeta("teleportOnLogin", true).booleanValue()) {
                                    PlotPlayer.this.teleport(location, TeleportCause.LOGIN);
                                    PlotPlayer.this.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_plot"), new TagResolver[0]);
                                }
                            });
                        } else if (!PlotSquared.get().isMainThread(Thread.currentThread()) && PlotPlayer.this.getMeta("teleportOnLogin", true).booleanValue()) {
                            plot.teleportPlayer(PlotPlayer.this, bl -> TaskManager.runTask(() -> {
                                if (PlotPlayer.this.getMeta("teleportOnLogin", true).booleanValue() && plot.isLoaded()) {
                                    PlotPlayer.this.teleport(location, TeleportCause.LOGIN);
                                    PlotPlayer.this.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_plot"), new TagResolver[0]);
                                }
                            }));
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            });
        }
    }

    byte[] getPersistentMeta(String string) {
        return this.metaMap.get(string);
    }

    Object removePersistentMeta(String string) {
        byte[] byArray = this.metaMap.remove(string);
        if (Settings.Enabled_Components.PERSISTENT_META) {
            DBFunc.removePersistentMeta(this.getUUID(), string);
        }
        return byArray;
    }

    public <T> @NonNull MetaDataAccess<T> accessPersistentMetaData(@NonNull MetaDataKey<T> metaDataKey) {
        return new PersistentMetaDataAccess<T>(this, metaDataKey, this.lockRepository.lock(metaDataKey.getLockKey()));
    }

    public <T> @NonNull MetaDataAccess<T> accessTemporaryMetaData(@NonNull MetaDataKey<T> metaDataKey) {
        return new TemporaryMetaDataAccess<T>(this, metaDataKey, this.lockRepository.lock(metaDataKey.getLockKey()));
    }

    <T> void setPersistentMeta(@NonNull MetaDataKey<T> metaDataKey, @NonNull T t) {
        if (metaDataKey.getType().getRawType().equals(Integer.class)) {
            this.setPersistentMeta(metaDataKey.toString(), Ints.toByteArray((int)((Integer)t)));
        } else if (metaDataKey.getType().getRawType().equals(Boolean.class)) {
            this.setPersistentMeta(metaDataKey.toString(), ByteArrayUtilities.booleanToBytes((Boolean)t));
        } else {
            throw new IllegalArgumentException(String.format("Unknown meta data type '%s'", metaDataKey.getType()));
        }
    }

    <T> @Nullable T getPersistentMeta(@NonNull MetaDataKey<T> metaDataKey) {
        Constable constable;
        byte[] byArray = this.getPersistentMeta(metaDataKey.toString());
        if (byArray == null) {
            return null;
        }
        if (metaDataKey.getType().getRawType().equals(Integer.class)) {
            constable = Ints.fromByteArray((byte[])byArray);
        } else if (metaDataKey.getType().getRawType().equals(Boolean.class)) {
            constable = Boolean.valueOf(ByteArrayUtilities.bytesToBoolean(byArray));
        } else {
            throw new IllegalArgumentException(String.format("Unknown meta data type '%s'", metaDataKey.getType()));
        }
        return (T)constable;
    }

    void setPersistentMeta(String string, byte[] byArray) {
        boolean bl = this.hasPersistentMeta(string);
        this.metaMap.put(string, byArray);
        if (Settings.Enabled_Components.PERSISTENT_META) {
            DBFunc.addPersistentMeta(this.getUUID(), string, byArray, bl);
        }
    }

    public void sendTitle(@NonNull Caption caption, @NonNull Caption caption2, TagResolver ... tagResolverArray) {
        this.sendTitle(caption, caption2, Settings.Titles.TITLES_FADE_IN, Settings.Titles.TITLES_STAY, Settings.Titles.TITLES_FADE_OUT, tagResolverArray);
    }

    public void sendTitle(@NonNull Caption caption, @NonNull Caption caption2, int n, int n2, int n3, TagResolver ... tagResolverArray) {
        Component component = MiniMessage.miniMessage().deserialize(caption.getComponent(this), tagResolverArray);
        Component component2 = MiniMessage.miniMessage().deserialize(caption2.getComponent(this), tagResolverArray);
        Title.Times times = Title.Times.times(Duration.of((long)Settings.Titles.TITLES_FADE_IN * 50L, ChronoUnit.MILLIS), Duration.of((long)Settings.Titles.TITLES_STAY * 50L, ChronoUnit.MILLIS), Duration.of((long)Settings.Titles.TITLES_FADE_OUT * 50L, ChronoUnit.MILLIS));
        this.getAudience().showTitle(Title.title(component, component2, times));
    }

    public void sendActionBar(@NonNull Caption caption, TagResolver ... tagResolverArray) {
        Object object;
        try {
            object = caption.getComponent(this);
        }
        catch (CaptionMap.NoSuchCaptionException noSuchCaptionException) {
            object = NON_EXISTENT_CAPTION + ((TranslatableCaption)caption).getKey();
            noSuchCaptionException.printStackTrace();
        }
        if (((String)object).isEmpty()) {
            return;
        }
        object = CaptionUtility.format(this, (String)object).replace('\u2010', '%').replace('\u2020', '&').replace('\u2030', '&').replace("<prefix>", TranslatableCaption.of("core.prefix").getComponent(this));
        Component component = MiniMessage.miniMessage().deserialize((String)object, tagResolverArray);
        this.getAudience().sendActionBar(component);
    }

    @Override
    public void sendMessage(@NonNull Caption caption, TagResolver ... tagResolverArray) {
        Object object;
        try {
            object = caption.getComponent(this);
        }
        catch (CaptionMap.NoSuchCaptionException noSuchCaptionException) {
            object = NON_EXISTENT_CAPTION + ((TranslatableCaption)caption).getKey();
            noSuchCaptionException.printStackTrace();
        }
        if (((String)object).isEmpty()) {
            return;
        }
        object = CaptionUtility.format(this, (String)object).replace('\u2010', '%').replace('\u2020', '&').replace('\u2030', '&').replace("<prefix>", TranslatableCaption.of("core.prefix").getComponent(this));
        Component component = MiniMessage.miniMessage().deserialize((String)object, tagResolverArray);
        if (!Objects.equal((Object)component, this.getMeta("lastMessage")) || System.currentTimeMillis() - (Long)this.getMeta("lastMessageTime") > 5000L) {
            this.setMeta("lastMessage", component);
            this.setMeta("lastMessageTime", System.currentTimeMillis());
            this.getAudience().sendMessage(component);
        }
    }

    public final CompletableFuture<Void> sendMessage(@NonNull Caption caption, CompletableFuture<@NonNull TagResolver> completableFuture) {
        return this.sendMessage(caption, new CompletableFuture[]{completableFuture}, new TagResolver[0]);
    }

    public final CompletableFuture<Void> sendMessage(@NonNull Caption caption, CompletableFuture<@NonNull TagResolver>[] completableFutureArray, TagResolver ... tagResolverArray) {
        return CompletableFuture.allOf(completableFutureArray).whenComplete((void_, throwable) -> {
            HashSet<TagResolver> hashSet = new HashSet<TagResolver>(Arrays.asList(tagResolverArray));
            if (throwable != null) {
                this.sendMessage((Caption)TranslatableCaption.of("errors.error"), TagResolver.resolver("value", Tag.inserting(Component.text("Failed to resolve asynchronous caption replacements"))));
                LOGGER.error("Failed to resolve asynchronous tagresolver(s) for " + caption, throwable);
            } else {
                for (CompletableFuture completableFuture : completableFutureArray) {
                    hashSet.add((TagResolver)completableFuture.join());
                }
            }
            this.sendMessage(caption, (TagResolver[])hashSet.toArray(TagResolver[]::new));
        });
    }

    @Override
    public boolean hasPermission(@NonNull String string) {
        return this.hasPermission(null, string);
    }

    boolean hasPersistentMeta(String string) {
        return this.metaMap.containsKey(string);
    }

    public abstract boolean canSee(PlotPlayer<?> var1);

    public abstract void stopSpectating();

    public boolean hasDebugMode() {
        return this.getAttribute("debug");
    }

    @Override
    public @NonNull Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.forLanguageTag(Settings.Enabled_Components.DEFAULT_LOCALE);
        }
        return this.locale;
    }

    @Override
    public void setLocale(@NonNull Locale locale) {
        this.locale = !PlotSquared.get().getCaptionMap("plotsquared").supportsLocale(locale) ? Locale.forLanguageTag(Settings.Enabled_Components.DEFAULT_LOCALE) : locale;
    }

    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + this.getUUID().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlotPlayer)) {
            return false;
        }
        PlotPlayer plotPlayer = (PlotPlayer)object;
        return this.getUUID().equals(plotPlayer.getUUID());
    }

    public abstract @NonNull Audience getAudience();

    public @NonNull LockRepository getLockRepository() {
        return this.lockRepository;
    }

    public abstract void removeEffect(@NonNull String var1);

    @FunctionalInterface
    public static interface PlotPlayerConverter<BaseObject> {
        public PlotPlayer<?> convert(BaseObject var1);
    }
}

