/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PlotAreaTerrainType {
    NONE,
    ORE,
    ROAD,
    ALL;

    private static final Map<String, PlotAreaTerrainType> types;

    public static Optional<PlotAreaTerrainType> fromString(String string) {
        return Optional.ofNullable(types.get(string.toLowerCase()));
    }

    @Deprecated
    public static Optional<PlotAreaTerrainType> fromLegacyInt(int n) {
        if (n < 0 || n >= PlotAreaTerrainType.values().length) {
            return Optional.empty();
        }
        return Optional.of(PlotAreaTerrainType.values()[n]);
    }

    static {
        types = Stream.of(PlotAreaTerrainType.values()).collect(Collectors.toMap(plotAreaTerrainType -> plotAreaTerrainType.toString().toLowerCase(), Function.identity()));
    }
}

