/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotItemStack;
import com.plotsquared.core.util.InventoryUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlotInventory {
    private final PlotPlayer<?> player;
    private final int lines;
    private final PlotItemStack[] items;
    private final InventoryUtil inventoryUtil;
    private String title;
    private boolean open = false;

    public PlotInventory(@NonNull InventoryUtil inventoryUtil, PlotPlayer<?> plotPlayer, int n, String string) {
        this.lines = n;
        this.title = string == null ? "" : string;
        this.player = plotPlayer;
        this.items = new PlotItemStack[n * 9];
        this.inventoryUtil = inventoryUtil;
    }

    public static boolean hasPlotInventoryOpen(@NonNull PlotPlayer<?> plotPlayer) {
        return PlotInventory.getOpenPlotInventory(plotPlayer) != null;
    }

    public static PlotInventory getOpenPlotInventory(@NonNull PlotPlayer<?> plotPlayer) {
        try (MetaDataAccess<PlotInventory> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_INVENTORY);){
            PlotInventory plotInventory = metaDataAccess.get().orElse(null);
            return plotInventory;
        }
    }

    public static void setPlotInventoryOpen(@NonNull PlotPlayer<?> plotPlayer, @NonNull PlotInventory plotInventory) {
        try (MetaDataAccess<PlotInventory> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_INVENTORY);){
            metaDataAccess.set(plotInventory);
        }
    }

    public static void removePlotInventoryOpen(@NonNull PlotPlayer<?> plotPlayer) {
        try (MetaDataAccess<PlotInventory> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_INVENTORY);){
            metaDataAccess.remove();
        }
    }

    public boolean onClick(int n) {
        return true;
    }

    public void openInventory() {
        if (this.title == null) {
            return;
        }
        if (!PlotInventory.hasPlotInventoryOpen(this.getPlayer())) {
            this.open = true;
            PlotInventory.setPlotInventoryOpen(this.getPlayer(), this);
            this.inventoryUtil.open(this);
        }
    }

    public void close() {
        if (this.title == null) {
            return;
        }
        PlotInventory.removePlotInventoryOpen(this.getPlayer());
        this.inventoryUtil.close(this);
        this.open = false;
    }

    public void setItem(int n, PlotItemStack plotItemStack) {
        this.setItemChecked(n, plotItemStack);
    }

    public boolean setItemChecked(int n, PlotItemStack plotItemStack) {
        if (!this.inventoryUtil.setItemChecked(this, n, plotItemStack)) {
            return false;
        }
        this.items[n] = plotItemStack;
        return true;
    }

    public PlotItemStack getItem(int n) {
        if (n < 0 || n >= this.items.length) {
            return null;
        }
        return this.items[n];
    }

    public PlotItemStack[] getItems() {
        return this.items;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        if (string == null) {
            return;
        }
        boolean bl = this.open;
        this.close();
        this.title = string;
        if (bl) {
            this.openInventory();
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public PlotPlayer<?> getPlayer() {
        return this.player;
    }

    public int getLines() {
        return this.lines;
    }
}

