/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.expiration;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.expiration.ExpiryTask;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.AnalysisFlag;
import com.plotsquared.core.plot.flag.implementations.KeepFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpireManager {
    private final ConcurrentHashMap<UUID, Long> dates_cache;
    private final ConcurrentHashMap<UUID, Long> account_age_cache;
    private final EventDispatcher eventDispatcher;
    private final ArrayDeque<ExpiryTask> tasks = new ArrayDeque();
    private volatile HashSet<Plot> plotsToDelete;
    private int running;

    @Inject
    public ExpireManager(@NonNull EventDispatcher eventDispatcher) {
        this.dates_cache = new ConcurrentHashMap();
        this.account_age_cache = new ConcurrentHashMap();
        this.eventDispatcher = eventDispatcher;
    }

    public void addTask(ExpiryTask expiryTask) {
        this.tasks.add(expiryTask);
    }

    public void handleJoin(PlotPlayer<?> plotPlayer) {
        this.storeDate(plotPlayer.getUUID(), System.currentTimeMillis());
        if (this.plotsToDelete != null && !this.plotsToDelete.isEmpty()) {
            for (Plot plot : plotPlayer.getPlots()) {
                this.plotsToDelete.remove(plot);
            }
        }
        this.confirmExpiry(plotPlayer);
    }

    public void handleEntry(PlotPlayer<?> plotPlayer, Plot plot) {
        if (this.plotsToDelete != null && !this.plotsToDelete.isEmpty() && plotPlayer.hasPermission("plots.admin.command.autoclear") && this.plotsToDelete.contains(plot)) {
            if (!this.isExpired(new ArrayDeque<ExpiryTask>(this.tasks), plot).isEmpty()) {
                this.confirmExpiry(plotPlayer);
            } else {
                this.plotsToDelete.remove(plot);
                this.confirmExpiry(plotPlayer);
            }
        }
    }

    public long getAccountAge(UUID uUID) {
        Long l = this.account_age_cache.get(uUID);
        return l == null ? Long.MAX_VALUE : l;
    }

    public long getTimestamp(UUID uUID) {
        Long l = this.dates_cache.get(uUID);
        return l == null ? 0L : l;
    }

    public void updateExpired(Plot plot) {
        if (this.plotsToDelete != null && !this.plotsToDelete.isEmpty() && this.plotsToDelete.contains(plot) && this.isExpired(new ArrayDeque<ExpiryTask>(this.tasks), plot).isEmpty()) {
            this.plotsToDelete.remove(plot);
        }
    }

    public void confirmExpiry(PlotPlayer<?> plotPlayer) {
        TaskManager.runTask(() -> {
            try (MetaDataAccess<Boolean> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_IGNORE_EXPIRE_TASK);){
                if (metaDataAccess.isPresent()) {
                    return;
                }
                if (this.plotsToDelete != null && !this.plotsToDelete.isEmpty() && plotPlayer.hasPermission("plots.admin.command.autoclear")) {
                    int n = this.plotsToDelete.size();
                    while (!this.plotsToDelete.isEmpty()) {
                        Iterator<Plot> iterator = this.plotsToDelete.iterator();
                        Plot plot = iterator.next();
                        if (!this.isExpired(new ArrayDeque<ExpiryTask>(this.tasks), plot).isEmpty()) {
                            metaDataAccess.set(true);
                            plot.getCenter(plotPlayer::teleport);
                            metaDataAccess.remove();
                            TranslatableCaption translatableCaption = TranslatableCaption.of("expiry.expired_options_clicky");
                            TagResolver tagResolver = TagResolver.builder().tag("num", Tag.inserting(Component.text(n))).tag("are_or_is", Tag.inserting(Component.text(n > 1 ? "plots are" : "plot is"))).tag("list_cmd", Tag.preProcessParsed("/plot list expired")).tag("plot", Tag.inserting(Component.text(plot.toString()))).tag("cmd_del", Tag.preProcessParsed("/plot delete")).tag("cmd_keep_1d", Tag.preProcessParsed("/plot flag set keep 1d")).tag("cmd_keep", Tag.preProcessParsed("/plot flag set keep true")).tag("cmd_no_show_expir", Tag.preProcessParsed("/plot toggle clear-confirmation")).build();
                            plotPlayer.sendMessage((Caption)translatableCaption, tagResolver);
                            return;
                        }
                        iterator.remove();
                    }
                    this.plotsToDelete.clear();
                }
            }
        });
    }

    public boolean cancelTask() {
        if (this.running != 2) {
            return false;
        }
        this.running = 1;
        return true;
    }

    public boolean runAutomatedTask() {
        return this.runTask(new RunnableVal3<Plot, Runnable, Boolean>(){

            @Override
            public void run(Plot plot, Runnable runnable, Boolean bl) {
                if (bl.booleanValue()) {
                    if (ExpireManager.this.plotsToDelete == null) {
                        ExpireManager.this.plotsToDelete = new HashSet();
                    }
                    ExpireManager.this.plotsToDelete.add(plot);
                    runnable.run();
                } else {
                    ExpireManager.this.deleteWithMessage(plot, runnable);
                }
            }
        });
    }

    public Collection<ExpiryTask> isExpired(ArrayDeque<ExpiryTask> arrayDeque, Plot plot) {
        ExpiryTask expiryTask;
        int n;
        int n2;
        for (n2 = 0; n2 < arrayDeque.size(); ++n2) {
            ExpiryTask expiryTask2 = arrayDeque.poll();
            if (!expiryTask2.applies(plot.getArea())) continue;
            arrayDeque.add(expiryTask2);
        }
        if (arrayDeque.isEmpty()) {
            return new ArrayList<ExpiryTask>();
        }
        if (((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue()) {
            return new ArrayList<ExpiryTask>();
        }
        n2 = 0;
        for (n = 0; n < arrayDeque.size(); ++n) {
            expiryTask = arrayDeque.poll();
            if (!expiryTask.applies(this.getAge(plot, expiryTask.shouldDeleteForUnknownOwner()))) continue;
            arrayDeque.add(expiryTask);
            n2 |= expiryTask.getSettings().SKIP_ACCOUNT_AGE_DAYS != -1 ? 1 : 0;
        }
        if (arrayDeque.isEmpty()) {
            return new ArrayList<ExpiryTask>();
        }
        if (n2 != 0) {
            for (n = 0; n < arrayDeque.size(); ++n) {
                long l;
                expiryTask = arrayDeque.poll();
                if (!expiryTask.appliesAccountAge(l = this.getAge(plot, expiryTask.shouldDeleteForUnknownOwner()))) continue;
                arrayDeque.add(expiryTask);
            }
            if (arrayDeque.isEmpty()) {
                return new ArrayList<ExpiryTask>();
            }
        }
        for (n = 0; n < arrayDeque.size(); ++n) {
            expiryTask = arrayDeque.poll();
            if (!(expiryTask.needsAnalysis() && plot.getArea().getType() == PlotAreaType.NORMAL || expiryTask.requiresConfirmation())) {
                return Collections.singletonList(expiryTask);
            }
            arrayDeque.add(expiryTask);
        }
        for (n = 0; n < arrayDeque.size(); ++n) {
            expiryTask = arrayDeque.poll();
            if (!expiryTask.needsAnalysis() || plot.getArea().getType() != PlotAreaType.NORMAL) {
                return Collections.singletonList(expiryTask);
            }
            arrayDeque.add(expiryTask);
        }
        return arrayDeque;
    }

    public ArrayDeque<ExpiryTask> getTasks(PlotArea plotArea) {
        ArrayDeque<ExpiryTask> arrayDeque = new ArrayDeque<ExpiryTask>(this.tasks);
        arrayDeque.removeIf(expiryTask -> !expiryTask.applies(plotArea));
        return arrayDeque;
    }

    public void passesComplexity(PlotAnalysis plotAnalysis, Collection<ExpiryTask> collection, RunnableVal<Boolean> runnableVal, Runnable runnable) {
        if (plotAnalysis != null) {
            for (ExpiryTask expiryTask : collection) {
                if (expiryTask.requiresConfirmation() || !expiryTask.applies(plotAnalysis)) continue;
                runnableVal.run(false);
                return;
            }
            for (ExpiryTask expiryTask : collection) {
                if (!expiryTask.applies(plotAnalysis)) continue;
                runnableVal.run(true);
                return;
            }
            runnable.run();
        }
    }

    public boolean runTask(final RunnableVal3<Plot, Runnable, Boolean> runnableVal3) {
        if (this.running != 0) {
            return false;
        }
        this.running = 2;
        TaskManager.runTaskAsync(new Runnable(){
            private ConcurrentLinkedDeque<Plot> plots = null;

            @Override
            public void run() {
                final 2 var1_1 = this;
                if (ExpireManager.this.running != 2) {
                    ExpireManager.this.running = 0;
                    return;
                }
                if (this.plots == null) {
                    this.plots = new ConcurrentLinkedDeque<Plot>(PlotQuery.newQuery().allPlots().asList());
                }
                while (!this.plots.isEmpty()) {
                    if (ExpireManager.this.running != 2) {
                        ExpireManager.this.running = 0;
                        return;
                    }
                    ArrayDeque<ExpiryTask> arrayDeque = new ArrayDeque<ExpiryTask>(ExpireManager.this.tasks);
                    final Plot plot = this.plots.poll();
                    PlotArea plotArea = plot.getArea();
                    final Plot plot2 = plotArea.getPlot(plot.getId());
                    final Collection<ExpiryTask> collection = ExpireManager.this.isExpired(arrayDeque, plot2);
                    if (collection.isEmpty()) continue;
                    for (ExpiryTask object2 : collection) {
                        if (object2.needsAnalysis()) continue;
                        runnableVal3.run(plot2, () -> TaskManager.getPlatformImplementation().taskLaterAsync(var1_1, TaskTime.ticks(1L)), object2.requiresConfirmation());
                        return;
                    }
                    RunnableVal<PlotAnalysis> runnableVal = new RunnableVal<PlotAnalysis>(){

                        @Override
                        public void run(PlotAnalysis plotAnalysis) {
                            ExpireManager.this.passesComplexity(plotAnalysis, collection, new RunnableVal<Boolean>(){

                                @Override
                                public void run(Boolean bl) {
                                    runnableVal3.run(plot2, () -> TaskManager.getPlatformImplementation().taskLaterAsync(var1_1, TaskTime.ticks(1L)), bl);
                                }
                            }, () -> {
                                Object f = GlobalFlagContainer.getInstance().getFlag(AnalysisFlag.class).createFlagInstance(plotAnalysis.asList());
                                PlotFlagAddEvent plotFlagAddEvent = ExpireManager.this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)f, plot);
                                if (plotFlagAddEvent.getEventResult() == Result.DENY) {
                                    return;
                                }
                                plot2.setFlag(plotFlagAddEvent.getFlag());
                                TaskManager.runTaskLaterAsync(var1_1, TaskTime.seconds(1L));
                            });
                        }
                    };
                    final Runnable runnable = () -> PlotSquared.platform().hybridUtils().analyzePlot(plot2, runnableVal);
                    PlotAnalysis plotAnalysis = plot2.getComplexity(null);
                    if (plotAnalysis != null) {
                        ExpireManager.this.passesComplexity(plotAnalysis, collection, new RunnableVal<Boolean>(){

                            @Override
                            public void run(Boolean bl) {
                                runnable.run();
                            }
                        }, () -> TaskManager.getPlatformImplementation().taskLaterAsync(var1_1, TaskTime.ticks(1L)));
                    } else {
                        runnable.run();
                    }
                    return;
                }
                if (this.plots.isEmpty()) {
                    ExpireManager.this.running = 3;
                    TaskManager.runTaskLater(() -> {
                        if (ExpireManager.this.running == 3) {
                            ExpireManager.this.running = 2;
                            ExpireManager.this.runTask(runnableVal3);
                        }
                    }, TaskTime.ticks(86400000L));
                } else {
                    TaskManager.runTaskLaterAsync(var1_1, TaskTime.seconds(10L));
                }
            }
        });
        return true;
    }

    public void storeDate(UUID uUID, long l) {
        Long l2;
        long l3;
        Long l4 = this.dates_cache.put(uUID, l);
        if (l4 != null && (l3 = l - l4) > 0L && (l2 = this.account_age_cache.get(uUID)) != null) {
            this.account_age_cache.put(uUID, l2 + l3);
        }
    }

    public HashSet<Plot> getPendingExpired() {
        return this.plotsToDelete == null ? new HashSet<Plot>() : this.plotsToDelete;
    }

    public void deleteWithMessage(Plot plot, Runnable runnable) {
        PlotPlayer<?> plotPlayer;
        Iterator<UUID> iterator;
        if (plot.isMerged() && ((PlotUnlinkEvent)((Object)(iterator = this.eventDispatcher.callUnlink(plot.getArea(), plot, true, false, PlotUnlinkEvent.REASON.EXPIRE_DELETE)))).getEventResult() != Result.DENY && plot.getPlotModificationManager().unlinkPlot(((PlotUnlinkEvent)((Object)iterator)).isCreateRoad(), ((PlotUnlinkEvent)((Object)iterator)).isCreateSign())) {
            this.eventDispatcher.callPostUnlink(plot, PlotUnlinkEvent.REASON.EXPIRE_DELETE);
        }
        for (UUID uUID : plot.getTrusted()) {
            plotPlayer = PlotSquared.platform().playerManager().getPlayerIfExists(uUID);
            if (plotPlayer == null) continue;
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("trusted.plot_removed_user"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.toString()))));
        }
        for (UUID uUID : plot.getMembers()) {
            plotPlayer = PlotSquared.platform().playerManager().getPlayerIfExists(uUID);
            if (plotPlayer == null) continue;
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("trusted.plot_removed_user"), TagResolver.resolver("plot", Tag.inserting(Component.text(plot.toString()))));
        }
        plot.getPlotModificationManager().deletePlot(null, runnable);
    }

    public long getAge(UUID uUID, boolean bl) {
        if (PlotSquared.platform().playerManager().getPlayerIfExists(uUID) != null) {
            return 0L;
        }
        Long l = this.dates_cache.get(uUID);
        if (l == null) {
            OfflinePlotPlayer offlinePlotPlayer = PlotSquared.platform().playerManager().getOfflinePlayer(uUID);
            if (offlinePlotPlayer != null && (l = Long.valueOf(offlinePlotPlayer.getLastPlayed())) != 0L) {
                this.dates_cache.put(uUID, l);
            } else {
                return bl ? Long.MAX_VALUE : 0L;
            }
        }
        if (l == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - l;
    }

    public long getAge(Plot plot, boolean bl) {
        if (!plot.hasOwner() || Objects.equals(DBFunc.EVERYONE, plot.getOwner()) || PlotSquared.platform().playerManager().getPlayerIfExists(plot.getOwner()) != null || plot.getRunning() > 0) {
            return 0L;
        }
        Object t = plot.getFlag(KeepFlag.class);
        if (!t.equals(false)) {
            if (t instanceof Boolean) {
                if (Boolean.TRUE.equals(t)) {
                    return 0L;
                }
            } else if (t instanceof Long) {
                if ((Long)t > System.currentTimeMillis()) {
                    return 0L;
                }
            } else {
                return 0L;
            }
        }
        long l = Long.MAX_VALUE;
        for (UUID uUID : plot.getOwners()) {
            long l2 = this.getAge(uUID, bl);
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }
}

