/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.TimeUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class KeepFlag
extends PlotFlag<Object, KeepFlag> {
    public static final KeepFlag KEEP_FLAG_FALSE = new KeepFlag(false);

    protected KeepFlag(@NonNull Object object) {
        super(object, TranslatableCaption.of("flags.flag_category_mixed"), TranslatableCaption.of("flags.flag_description_keep"));
    }

    @Override
    public KeepFlag parse(@NonNull String string) {
        if (MathMan.isInteger(string)) {
            long l = Long.parseLong(string);
            if (l < 0L) {
                throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_keep"), new TagResolver[0]);
            }
            return this.flagOf((Object)l);
        }
        return switch (string.toLowerCase()) {
            case "true" -> this.flagOf((Object)true);
            case "false" -> this.flagOf((Object)false);
            default -> this.flagOf((Object)(TimeUtil.timeToSec(string) * 1000L + System.currentTimeMillis()));
        };
    }

    @Override
    public KeepFlag merge(@NonNull Object object) {
        if (object.equals(true)) {
            return this.flagOf((Object)true);
        }
        if (object.equals(false)) {
            if (this.getValue().equals(true) || this.getValue().equals(false)) {
                return this;
            }
            return this.flagOf(object);
        }
        if (this.getValue().equals(true)) {
            return this;
        }
        if (this.getValue().equals(false)) {
            return this.flagOf(object);
        }
        long l = (Long)this.getValue();
        return this.flagOf((Object)((Long)object + l));
    }

    @Override
    public String toString() {
        return this.getValue().toString();
    }

    @Override
    public String getExample() {
        return "3w 4d 2h";
    }

    @Override
    protected KeepFlag flagOf(@NonNull Object object) {
        return new KeepFlag(object);
    }
}

