/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.types.BlockTypeWrapper;
import com.plotsquared.core.plot.flag.types.ListFlag;
import com.plotsquared.core.util.BlockUtil;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class BlockTypeListFlag<F extends ListFlag<BlockTypeWrapper, F>>
extends ListFlag<BlockTypeWrapper, F> {
    public static boolean skipCategoryVerification = false;

    protected BlockTypeListFlag(List<BlockTypeWrapper> list, Caption caption) {
        super(list, (Caption)TranslatableCaption.of("flags.flag_category_block_list"), caption);
    }

    @Override
    public F parse(@NonNull String string) {
        ArrayList<BlockTypeWrapper> arrayList = new ArrayList<BlockTypeWrapper>();
        String[] stringArray = string.replaceAll("\\s+", "").split(",(?![^\\(\\[]*[\\]\\)])");
        if (stringArray.length == 0) {
            return (F)((ListFlag)this.flagOf(arrayList));
        }
        for (String string2 : stringArray) {
            BlockState blockState = BlockUtil.get(string2);
            BlockTypeWrapper blockTypeWrapper = blockState == null ? this.getCategory(string2) : BlockTypeWrapper.get(blockState.getBlockType());
            if (arrayList.contains(blockTypeWrapper)) continue;
            arrayList.add(blockTypeWrapper);
        }
        return (F)((ListFlag)this.flagOf(arrayList));
    }

    @Override
    public String getExample() {
        return "air,grass_block";
    }

    @Override
    public Collection<String> getTabCompletions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(BlockType.REGISTRY.keySet().stream().map(string -> string.replace("minecraft:", "")).collect(Collectors.toList()));
        arrayList.addAll(BlockCategory.REGISTRY.keySet().stream().map(string -> "#" + string.replace("minecraft:", "")).collect(Collectors.toList()));
        return arrayList;
    }

    private BlockTypeWrapper getCategory(String string) {
        BlockTypeWrapper blockTypeWrapper;
        if (!string.startsWith("#")) {
            throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_invalid_block"), new TagResolver[0]);
        }
        String string2 = string.substring(1);
        if (skipCategoryVerification) {
            blockTypeWrapper = BlockTypeWrapper.get(string2);
        } else {
            BlockCategory blockCategory = (BlockCategory)BlockCategory.REGISTRY.get(string2);
            if (blockCategory == null) {
                throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_invalid_block"), new TagResolver[0]);
            }
            blockTypeWrapper = BlockTypeWrapper.get(blockCategory);
        }
        return blockTypeWrapper;
    }
}

