/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class BooleanFlag<F extends PlotFlag<Boolean, F>>
extends PlotFlag<Boolean, F> {
    private static final Collection<String> positiveValues = Arrays.asList("1", "yes", "allow", "true");
    private static final Collection<String> negativeValues = Arrays.asList("0", "no", "deny", "disallow", "false");

    protected BooleanFlag(boolean bl, Caption caption) {
        super(bl, TranslatableCaption.of("flags.flag_category_boolean"), caption);
    }

    protected BooleanFlag(Caption caption) {
        this(false, caption);
    }

    @Override
    public F parse(@NonNull String string) {
        if (positiveValues.contains(string.toLowerCase(Locale.ENGLISH))) {
            return this.flagOf(true);
        }
        if (negativeValues.contains(string.toLowerCase(Locale.ENGLISH))) {
            return this.flagOf(false);
        }
        throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_boolean"), new TagResolver[0]);
    }

    @Override
    public F merge(@NonNull Boolean bl) {
        return this.flagOf((Boolean)this.getValue() != false || bl != false);
    }

    @Override
    public String getExample() {
        return "true";
    }

    @Override
    public String toString() {
        return ((Boolean)this.getValue()).toString();
    }

    @Override
    public Collection<String> getTabCompletions() {
        return Arrays.asList("true", "false");
    }
}

