/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.types.NumberFlag;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class DoubleFlag<F extends NumberFlag<Double, F>>
extends NumberFlag<Double, F> {
    protected DoubleFlag(@NonNull Double d, Double d2, Double d3, @NonNull Caption caption) {
        super(d, d2, d3, TranslatableCaption.of("flags.flag_category_doubles"), caption);
    }

    protected DoubleFlag(@NonNull Double d, @NonNull Caption caption) {
        this(d, (Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE, caption);
    }

    @Override
    public F merge(@NonNull Double d) {
        return (F)((NumberFlag)this.flagOf((Double)this.getValue() + d));
    }

    @Override
    public String getExample() {
        return "12.175";
    }

    @Override
    public String toString() {
        return ((Double)this.getValue()).toString();
    }

    @Override
    protected @NonNull Double parseNumber(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Throwable throwable) {
            throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_double"), new TagResolver[0]);
        }
    }

    @Override
    public boolean isValuedPermission() {
        return false;
    }
}

