/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.types.NumberFlag;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class IntegerFlag<F extends NumberFlag<Integer, F>>
extends NumberFlag<Integer, F> {
    protected IntegerFlag(int n, int n2, int n3, @NonNull Caption caption) {
        super(n, n2, n3, TranslatableCaption.of("flags.flag_category_integers"), caption);
    }

    protected IntegerFlag(@NonNull Caption caption) {
        this(0, Integer.MIN_VALUE, Integer.MAX_VALUE, caption);
    }

    @Override
    public F merge(@NonNull Integer n) {
        return (F)((NumberFlag)this.flagOf((Integer)this.getValue() + n));
    }

    @Override
    public String toString() {
        return ((Integer)this.getValue()).toString();
    }

    @Override
    public String getExample() {
        return "10";
    }

    @Override
    protected @NonNull Integer parseNumber(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_integer"), new TagResolver[0]);
        }
    }
}

