/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.worldedit.function.pattern.Pattern;
import java.io.File;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SinglePlotManager
extends PlotManager {
    private static final int MAX_COORDINATE = 30000000;

    public SinglePlotManager(@NonNull PlotArea plotArea) {
        super(plotArea);
    }

    @Override
    public PlotId getPlotIdAbs(int n, int n2, int n3) {
        return PlotId.of(0, 0);
    }

    @Override
    public PlotId getPlotId(int n, int n2, int n3) {
        return PlotId.of(0, 0);
    }

    @Override
    public Location getPlotBottomLocAbs(@NonNull PlotId plotId) {
        return Location.at(plotId.toUnderscoreSeparatedString(), -30000000, 0, -30000000);
    }

    @Override
    public Location getPlotTopLocAbs(@NonNull PlotId plotId) {
        return Location.at(plotId.toUnderscoreSeparatedString(), 30000000, 0, 30000000);
    }

    @Override
    public boolean clearPlot(@NonNull Plot plot, Runnable runnable, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        PlotSquared.platform().setupUtils().unload(plot.getWorldName(), false);
        File file = new File(PlotSquared.platform().worldContainer(), plot.getWorldName());
        TaskManager.getPlatformImplementation().taskAsync(() -> {
            FileUtils.deleteDirectory(file);
            if (runnable != null) {
                runnable.run();
            }
        });
        return true;
    }

    @Override
    public boolean claimPlot(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        return true;
    }

    @Override
    public boolean unClaimPlot(@NonNull Plot plot, Runnable runnable, @Nullable QueueCoordinator queueCoordinator) {
        if (runnable != null) {
            runnable.run();
        }
        return true;
    }

    @Override
    public Location getSignLoc(@NonNull Plot plot) {
        return null;
    }

    @Override
    public String[] getPlotComponents(@NonNull PlotId plotId) {
        return new String[0];
    }

    @Override
    public boolean setComponent(@NonNull PlotId plotId, @NonNull String string, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean createRoadEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean createRoadSouth(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean createRoadSouthEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean removeRoadEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean removeRoadSouth(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean removeRoadSouthEast(@NonNull Plot plot, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean startPlotMerge(@NonNull List<PlotId> list, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean startPlotUnlink(@NonNull List<PlotId> list, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean finishPlotMerge(@NonNull List<PlotId> list, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean finishPlotUnlink(@NonNull List<PlotId> list, @Nullable QueueCoordinator queueCoordinator) {
        return false;
    }

    @Override
    public boolean regenerateAllPlotWalls(@Nullable QueueCoordinator queueCoordinator) {
        return false;
    }
}

