/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.annotations.informative.NotPublic;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@NotPublic
public class BlockArrayCacheScopedQueueCoordinator
extends ZeroedDelegateScopedQueueCoordinator {
    private final BlockState[][][] blockStates;
    private final int height;
    private final int width;
    private final int length;
    private final int minY;
    private final int maxY;
    private final int scopeMinX;
    private final int scopeMinZ;
    private final int scopeMaxX;
    private final int scopeMaxZ;
    private int offsetX = 0;
    private int offsetZ = 0;

    public BlockArrayCacheScopedQueueCoordinator(Location location, Location location2) {
        super(null, location, location2);
        this.width = location2.getX() - location.getX() + 1;
        this.length = location2.getZ() - location.getZ() + 1;
        this.minY = location.getY();
        this.maxY = location2.getY();
        this.height = this.maxY - this.minY + 1;
        this.scopeMinX = location.getX() & 0xF;
        this.scopeMinZ = location.getZ() & 0xF;
        this.scopeMaxX = this.scopeMinX + this.width;
        this.scopeMaxZ = this.scopeMinZ + this.length;
        this.blockStates = new BlockState[this.height][this.width][this.length];
    }

    public BlockState[][][] getBlockStates() {
        return this.blockStates;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BlockState blockState) {
        if ((n += this.offsetX) >= this.scopeMinX && n < this.scopeMaxX && n2 >= this.minY && n2 <= this.maxY && (n3 += this.offsetZ) >= this.scopeMinZ && n3 < this.scopeMaxZ) {
            this.blockStates[n2 - this.minY][n - this.scopeMinX][n3 - this.scopeMinZ] = blockState;
        }
        return false;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull Pattern pattern) {
        int n4 = n + this.offsetX;
        int n5 = n3 + this.offsetZ;
        if (n4 >= this.scopeMinX && n4 < this.scopeMaxX && n2 >= this.minY && n2 <= this.maxY && n5 >= this.scopeMinZ && n5 < this.scopeMaxZ) {
            BlockState blockState;
            this.blockStates[n2 - this.minY][n4 - this.scopeMinX][n5 - this.scopeMinZ] = blockState = pattern.applyBlock(super.getMin().getBlockVector3().add(BlockVector3.at((int)n, (int)n2, (int)n3))).toImmutableState();
        }
        return false;
    }

    @Override
    public @NonNull Location getMin() {
        return super.getMin().add(this.offsetX - this.scopeMinX, 0, this.offsetZ - this.scopeMinZ);
    }

    @Override
    public @NonNull Location getMax() {
        return this.getMin().add(15, 0, 15).withY(this.maxY);
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BaseBlock baseBlock) {
        if ((n += this.offsetX) >= this.scopeMinX && n < this.scopeMaxX && n2 >= this.minY && n2 <= this.maxY && (n3 += this.offsetZ) >= this.scopeMinZ && n3 < this.scopeMaxZ) {
            this.blockStates[n2 - this.minY][n - this.scopeMinX][n3 - this.scopeMinZ] = baseBlock.toImmutableState();
        }
        return false;
    }

    @Override
    public @Nullable BlockState getBlock(int n, int n2, int n3) {
        if (n >= 0 && n < this.width && n2 >= this.minY && n2 <= this.maxY && n3 >= 0 && n3 < this.length) {
            return this.blockStates[n2 - this.minY][n][n3];
        }
        return null;
    }

    public void setOffsetX(int n) {
        this.offsetX = n;
    }

    public void setOffsetZ(int n) {
        this.offsetZ = n;
    }

    @Override
    public int size() {
        return this.height * this.width * this.length;
    }

    @Override
    public boolean setBiome(int n, int n2, @NonNull BiomeType biomeType) {
        return false;
    }

    @Override
    public boolean setBiome(int n, int n2, int n3, @NonNull BiomeType biomeType) {
        return false;
    }

    @Override
    public void fillBiome(BiomeType biomeType) {
    }

    @Override
    public boolean setTile(int n, int n2, int n3, @NonNull CompoundTag compoundTag) {
        return false;
    }
}

