/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.queue.DelegateQueueCoordinator;
import com.plotsquared.core.queue.QueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LocationOffsetDelegateQueueCoordinator
extends DelegateQueueCoordinator {
    private final boolean[][] canPlace;
    private final int blockX;
    private final int blockZ;

    public LocationOffsetDelegateQueueCoordinator(boolean[][] blArray, int n, int n2, @Nullable QueueCoordinator queueCoordinator) {
        super(queueCoordinator);
        this.canPlace = blArray;
        this.blockX = n;
        this.blockZ = n2;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BlockState blockState) {
        if (this.canPlace[n - this.blockX][n3 - this.blockZ]) {
            return super.setBlock(n, n2, n3, blockState);
        }
        return false;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BaseBlock baseBlock) {
        if (this.canPlace[n - this.blockX][n3 - this.blockZ]) {
            return super.setBlock(n, n2, n3, baseBlock);
        }
        return false;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull Pattern pattern) {
        BlockVector3 blockVector3 = BlockVector3.at((int)(n + this.blockX), (int)n2, (int)(n3 + this.blockZ));
        return this.setBlock(n, n2, n3, pattern.applyBlock(blockVector3));
    }

    @Override
    public boolean setBiome(int n, int n2, @NonNull BiomeType biomeType) {
        if (this.canPlace[n - this.blockX][n2 - this.blockZ]) {
            return super.setBiome(n, n2, biomeType);
        }
        return false;
    }

    @Override
    public boolean setBiome(int n, int n2, int n3, @NonNull BiomeType biomeType) {
        if (this.canPlace[n - this.blockX][n3 - this.blockZ]) {
            return super.setBiome(n, n2, n3, biomeType);
        }
        return false;
    }

    @Override
    public boolean setTile(int n, int n2, int n3, @NonNull CompoundTag compoundTag) {
        if (this.canPlace[n - this.blockX][n3 - this.blockZ]) {
            return super.setTile(n, n2, n3, compoundTag);
        }
        return false;
    }
}

