/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.LightingMode;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.plotsquared.core.util.PatternUtil;
import com.plotsquared.google.Inject;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class QueueCoordinator {
    private final AtomicBoolean enqueued = new AtomicBoolean();
    private boolean forceSync = false;
    private @Nullable Object chunkObject;
    @Inject
    private GlobalBlockQueue blockQueue;

    public QueueCoordinator(@Nullable World world) {
        PlotSquared.platform().injector().injectMembers(this);
    }

    public ZeroedDelegateScopedQueueCoordinator getForChunk(int n, int n2, int n3, int n4) {
        int n5 = n << 4;
        int n6 = n2 << 4;
        return new ZeroedDelegateScopedQueueCoordinator(this, Location.at(this.getWorld().getName(), n5, n3, n6), Location.at(this.getWorld().getName(), n5 + 15, n4, n6 + 15));
    }

    public abstract int size();

    public abstract void setModified(long var1);

    public boolean isForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean bl) {
        this.forceSync = bl;
    }

    public @Nullable Object getChunkObject() {
        return this.chunkObject;
    }

    public void setChunkObject(@NonNull Object object) {
        this.chunkObject = object;
    }

    public abstract boolean setBlock(int var1, int var2, int var3, @NonNull BlockState var4);

    public abstract boolean setBlock(int var1, int var2, int var3, @NonNull BaseBlock var4);

    public boolean setBlock(int n, int n2, int n3, @NonNull Pattern pattern) {
        return this.setBlock(n, n2, n3, PatternUtil.apply(pattern, n, n2, n3));
    }

    public abstract boolean setTile(int var1, int var2, int var3, @NonNull CompoundTag var4);

    public abstract boolean isSettingTiles();

    public abstract @Nullable BlockState getBlock(int var1, int var2, int var3);

    @Deprecated(forRemoval=true, since="6.0.0")
    public abstract boolean setBiome(int var1, int var2, @NonNull BiomeType var3);

    public abstract boolean setBiome(int var1, int var2, int var3, @NonNull BiomeType var4);

    public abstract boolean isSettingBiomes();

    public abstract void setBiomesEnabled(boolean var1);

    public void addEntities(@NonNull List<? extends Entity> list) {
        for (Entity entity : list) {
            this.setEntity(entity);
        }
    }

    public abstract boolean setEntity(@NonNull Entity var1);

    public abstract @NonNull List<BlockVector2> getReadChunks();

    public abstract void addReadChunks(@NonNull Set<BlockVector2> var1);

    public abstract void addReadChunk(@NonNull BlockVector2 var1);

    public abstract boolean isUnloadAfter();

    public abstract void setUnloadAfter(boolean var1);

    public abstract @Nullable CuboidRegion getRegenRegion();

    public abstract void setRegenRegion(@NonNull CuboidRegion var1);

    public abstract void regenChunk(int var1, int var2);

    public abstract @Nullable World getWorld();

    public final void setModified() {
        this.setModified(System.currentTimeMillis());
    }

    public boolean enqueue() {
        boolean bl = false;
        if (this.enqueued.compareAndSet(false, true)) {
            bl = true;
            this.start();
        }
        return bl;
    }

    public abstract void start();

    public abstract void cancel();

    public abstract Runnable getCompleteTask();

    public abstract void setCompleteTask(@Nullable Runnable var1);

    public abstract @Nullable Consumer<BlockVector2> getChunkConsumer();

    public abstract void setChunkConsumer(@NonNull Consumer<BlockVector2> var1);

    public abstract void addProgressSubscriber(@NonNull ProgressSubscriber var1);

    public abstract @NonNull LightingMode getLightingMode();

    public abstract void setLightingMode(@Nullable LightingMode var1);

    public abstract @Nullable SideEffectSet getSideEffectSet();

    public abstract void setSideEffectSet(@Nullable SideEffectSet var1);

    public void setCuboid(@NonNull Location location, @NonNull Location location2, @NonNull BlockState blockState) {
        int n = Math.min(location.getY(), location2.getY());
        int n2 = Math.max(location.getY(), location2.getY());
        int n3 = Math.min(location.getX(), location2.getX());
        int n4 = Math.max(location.getX(), location2.getX());
        int n5 = Math.min(location.getZ(), location2.getZ());
        int n6 = Math.max(location.getZ(), location2.getZ());
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                for (int k = n5; k <= n6; ++k) {
                    this.setBlock(j, i, k, blockState);
                }
            }
        }
    }

    public void setCuboid(@NonNull Location location, @NonNull Location location2, @NonNull Pattern pattern) {
        int n = Math.min(location.getY(), location2.getY());
        int n2 = Math.max(location.getY(), location2.getY());
        int n3 = Math.min(location.getX(), location2.getX());
        int n4 = Math.max(location.getX(), location2.getX());
        int n5 = Math.min(location.getZ(), location2.getZ());
        int n6 = Math.max(location.getZ(), location2.getZ());
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                for (int k = n5; k <= n6; ++k) {
                    this.setBlock(j, i, k, pattern);
                }
            }
        }
    }

    public void setBiomeCuboid(@NonNull Location location, @NonNull Location location2, @NonNull BiomeType biomeType) {
        int n = Math.min(location.getY(), location2.getY());
        int n2 = Math.max(location.getY(), location2.getY());
        int n3 = Math.min(location.getX(), location2.getX());
        int n4 = Math.max(location.getX(), location2.getX());
        int n5 = Math.min(location.getZ(), location2.getZ());
        int n6 = Math.max(location.getZ(), location2.getZ());
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                for (int k = n5; k <= n6; ++k) {
                    this.setBiome(j, i, k, biomeType);
                }
            }
        }
    }

    protected int getMinY() {
        return this.getWorld() != null ? this.getWorld().getMinY() : PlotSquared.platform().versionMinHeight();
    }

    protected int getMaxY() {
        return this.getWorld() != null ? this.getWorld().getMinY() : PlotSquared.platform().versionMaxHeight();
    }

    protected int getMinLayer() {
        return (this.getWorld() != null ? this.getWorld().getMinY() : PlotSquared.platform().versionMinHeight()) >> 4;
    }

    protected int getMaxLayer() {
        return (this.getWorld() != null ? this.getWorld().getMaxY() : PlotSquared.platform().versionMaxHeight()) >> 4;
    }
}

