/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.services;

import com.plotsquared.core.geantyref.TypeToken;
import com.plotsquared.core.services.PipelineException;
import com.plotsquared.core.services.types.Service;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

enum ServiceFilterHandler {
    INSTANCE;


    <Context> boolean passes( @NonNull ServiceRepository.ServiceWrapper<? extends Service<Context, ?>> serviceWrapper, @NonNull Context Context2) {
        if (!serviceWrapper.isDefaultImplementation()) {
            for (Predicate predicate : serviceWrapper.getFilters()) {
                try {
                    if (predicate.test(Context2)) continue;
                    return false;
                }
                catch (Exception exception) {
                    throw new PipelineException(String.format("Failed to evaluate filter '%s' for '%s'", TypeToken.get(predicate.getClass()).getType().getTypeName(), serviceWrapper), exception);
                }
            }
        }
        return true;
    }
}

