/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.setup;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.annotations.annotations.Contract;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.setup.SettingsNodesWrapper;
import com.plotsquared.core.util.SetupUtils;
import java.util.Objects;

public class PlotAreaBuilder {
    private String generatorName;
    private String plotManager;
    @Nullable
    private PlotAreaType plotAreaType;
    private PlotAreaTerrainType terrainType;
    private String worldName;
    private String areaName;
    private PlotId minimumId;
    private PlotId maximumId;
    private SettingsNodesWrapper settingsNodesWrapper;
    private SetupUtils setupManager;

    private PlotAreaBuilder() {
    }

    public static PlotAreaBuilder newBuilder() {
        return new PlotAreaBuilder();
    }

    public static PlotAreaBuilder ofPlotArea(PlotArea plotArea) {
        return new PlotAreaBuilder().worldName(plotArea.getWorldName()).areaName(plotArea.getId()).plotAreaType(plotArea.getType()).terrainType(plotArea.getTerrain()).generatorName(plotArea.getGenerator().getName()).plotManager(PlotSquared.platform().pluginName()).minimumId(plotArea.getMin()).maximumId(plotArea.getMax()).settingsNodesWrapper(new SettingsNodesWrapper(plotArea.getSettingNodes(), null));
    }

    public PlotAreaBuilder minimumId(PlotId plotId) {
        if (this.maximumId != null && (plotId.getX() > this.maximumId.getX() || plotId.getY() > this.maximumId.getY())) {
            throw new IllegalStateException("minId >= maxId");
        }
        this.minimumId = plotId;
        return this;
    }

    public PlotAreaBuilder maximumId(PlotId plotId) {
        if (this.minimumId != null && (plotId.getX() < this.minimumId.getX() || plotId.getY() < this.minimumId.getY())) {
            throw new IllegalStateException("maxId <= minId");
        }
        this.maximumId = plotId;
        return this;
    }

    public String generatorName() {
        return this.generatorName;
    }

    public String plotManager() {
        return this.plotManager;
    }

    @NotNull
    @Contract(value=" -> !null")
    public PlotAreaType plotAreaType() {
        return Objects.requireNonNullElse(this.plotAreaType, PlotAreaType.NORMAL);
    }

    public PlotAreaTerrainType terrainType() {
        return this.terrainType;
    }

    public String worldName() {
        return this.worldName;
    }

    public String areaName() {
        return this.areaName;
    }

    public PlotId minimumId() {
        return this.minimumId;
    }

    public PlotId maximumId() {
        return this.maximumId;
    }

    public SettingsNodesWrapper settingsNodesWrapper() {
        return this.settingsNodesWrapper;
    }

    public SetupUtils setupManager() {
        return this.setupManager;
    }

    public PlotAreaBuilder generatorName(String string) {
        this.generatorName = string;
        return this;
    }

    public PlotAreaBuilder plotManager(String string) {
        this.plotManager = string;
        return this;
    }

    public PlotAreaBuilder plotAreaType(@NotNull PlotAreaType plotAreaType) {
        Objects.requireNonNull(plotAreaType, "PlotAreaType must not be null");
        this.plotAreaType = plotAreaType;
        return this;
    }

    public PlotAreaBuilder terrainType(PlotAreaTerrainType plotAreaTerrainType) {
        this.terrainType = plotAreaTerrainType;
        return this;
    }

    public PlotAreaBuilder worldName(String string) {
        this.worldName = string;
        return this;
    }

    public PlotAreaBuilder areaName(String string) {
        this.areaName = string;
        return this;
    }

    public PlotAreaBuilder settingsNodesWrapper(SettingsNodesWrapper settingsNodesWrapper) {
        this.settingsNodesWrapper = settingsNodesWrapper;
        return this;
    }

    public PlotAreaBuilder setupManager(SetupUtils setupUtils) {
        this.setupManager = setupUtils;
        return this;
    }
}

