/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.synchronization;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LockKey {
    private static final Map<String, LockKey> keyMap = new HashMap<String, LockKey>();
    private static final Object keyLock = new Object();
    private final String key;

    private LockKey(@NonNull String string) {
        this.key = (String)Preconditions.checkNotNull((Object)string, (Object)"Key may not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull LockKey of(@NonNull String string) {
        Object object = keyLock;
        synchronized (object) {
            return keyMap.computeIfAbsent(string, LockKey::new);
        }
    }

    static @NonNull Collection<LockKey> recognizedKeys() {
        return Collections.unmodifiableCollection(keyMap.values());
    }

    public String toString() {
        return "LockKey{key='" + this.key + "'}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LockKey lockKey = (LockKey)object;
        return Objects.equal((Object)this.key, (Object)lockKey.key);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key});
    }
}

