/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.plot.BlockBucket;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LegacyConverter {
    public static final String CONFIGURATION_VERSION = "post_flattening";
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + LegacyConverter.class.getSimpleName()));
    private static final HashMap<String, ConfigurationType> TYPE_MAP = new HashMap();
    private final ConfigurationSection configuration;

    public LegacyConverter(@NonNull ConfigurationSection configurationSection) {
        this.configuration = configurationSection;
    }

    private BlockBucket blockToBucket(@NonNull String string) {
        BlockState blockState = (BlockState)PlotSquared.platform().worldUtil().getClosestBlock((String)string).best;
        return BlockBucket.withSingle(blockState);
    }

    private void setString(@NonNull ConfigurationSection configurationSection, @NonNull String string, @NonNull BlockBucket blockBucket) {
        if (!configurationSection.contains(string)) {
            throw new IllegalArgumentException(String.format("No such key: %s", string));
        }
        configurationSection.set(string, blockBucket.toString());
    }

    private BlockBucket blockListToBucket(@NonNull BlockState[] blockStateArray) {
        HashMap<BlockState, Integer> hashMap = new HashMap<BlockState, Integer>();
        for (BlockState object : blockStateArray) {
            hashMap.putIfAbsent(object, 0);
            hashMap.put(object, (Integer)hashMap.get(object) + 1);
        }
        boolean bl = false;
        for (Integer n : hashMap.values()) {
            if (n <= 1) continue;
            bl = true;
            break;
        }
        BlockBucket blockBucket = new BlockBucket();
        if (bl) {
            for (Map.Entry entry : hashMap.entrySet()) {
                blockBucket.addBlock((BlockState)entry.getKey(), (Integer)entry.getValue());
            }
        } else {
            hashMap.keySet().forEach(blockBucket::addBlock);
        }
        return blockBucket;
    }

    private BlockState[] splitBlockList(@NonNull List<String> list) {
        return (BlockState[])list.stream().map(string -> (BlockState)PlotSquared.platform().worldUtil().getClosestBlock((String)string).best).toArray(BlockState[]::new);
    }

    private void convertBlock(@NonNull ConfigurationSection configurationSection, @NonNull String string, @NonNull String string2) {
        BlockBucket blockBucket = this.blockToBucket(string2);
        this.setString(configurationSection, string, blockBucket);
        ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("legacyconfig.legacy_config_replaced"), TagResolver.builder().tag("value1", Tag.inserting(Component.text(string2))).tag("value2", Tag.inserting(Component.text(blockBucket.toString()))).build());
    }

    private void convertBlockList(@NonNull ConfigurationSection configurationSection, @NonNull String string, @NonNull List<String> list) {
        BlockState[] blockStateArray = this.splitBlockList(list);
        BlockBucket blockBucket = this.blockListToBucket(blockStateArray);
        this.setString(configurationSection, string, blockBucket);
        ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("legacyconfig.legacy_config_replaced"), TagResolver.builder().tag("value1", Tag.inserting(Component.text(this.plotBlockArrayString(blockStateArray)))).tag("value2", Tag.inserting(Component.text(blockBucket.toString()))).build());
    }

    private String plotBlockArrayString(@NonNull BlockState[] blockStateArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < blockStateArray.length; ++i) {
            stringBuilder.append(blockStateArray[i].toString());
            if (i + 1 >= blockStateArray.length) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public void convert() {
        Set<String> set = this.configuration.getKeys(false);
        for (String string : set) {
            ConfigurationSection configurationSection = this.configuration.getConfigurationSection(string);
            for (Map.Entry<String, ConfigurationType> entry : TYPE_MAP.entrySet()) {
                if (!configurationSection.contains(entry.getKey())) continue;
                if (entry.getValue() == ConfigurationType.BLOCK) {
                    this.convertBlock(configurationSection, entry.getKey(), configurationSection.getString(entry.getKey()));
                    continue;
                }
                this.convertBlockList(configurationSection, entry.getKey(), configurationSection.getStringList(entry.getKey()));
            }
        }
    }

    static {
        TYPE_MAP.put("plot.filling", ConfigurationType.BLOCK_LIST);
        TYPE_MAP.put("plot.floor", ConfigurationType.BLOCK_LIST);
        TYPE_MAP.put("wall.filling", ConfigurationType.BLOCK);
        TYPE_MAP.put("wall.block_claimed", ConfigurationType.BLOCK);
        TYPE_MAP.put("wall.block", ConfigurationType.BLOCK);
        TYPE_MAP.put("road.block", ConfigurationType.BLOCK);
    }

    private static enum ConfigurationType {
        BLOCK,
        BLOCK_LIST;

    }
}

