/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

public class MathMan {
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final int ATAN2_DIM = (int)Math.sqrt(16384.0);
    private static final float INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(ATAN2_DIM - 1);
    private static final float[] atan2 = new float[16384];
    private static final int[] table = new int[]{0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61, 64, 65, 67, 69, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97, 98, 99, 101, 102, 103, 104, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 163, 164, 165, 166, 167, 167, 168, 169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181, 181, 182, 183, 183, 184, 185, 185, 186, 187, 187, 188, 189, 189, 190, 191, 192, 192, 193, 193, 194, 195, 195, 196, 197, 197, 198, 199, 199, 200, 201, 201, 202, 203, 203, 204, 204, 205, 206, 206, 207, 208, 208, 209, 209, 210, 211, 211, 212, 212, 213, 214, 214, 215, 215, 216, 217, 217, 218, 218, 219, 219, 220, 221, 221, 222, 222, 223, 224, 224, 225, 225, 226, 226, 227, 227, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 255};

    public static final int gcd(int n, int n2) {
        if (n2 == 0) {
            return n;
        }
        return MathMan.gcd(n2, n % n2);
    }

    public static final int gcd(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n = MathMan.gcd(n, nArray[i]);
        }
        return n;
    }

    public static double getMean(int[] nArray) {
        double d = 0.0;
        for (int n : nArray) {
            d += (double)n;
        }
        return d / (double)nArray.length;
    }

    public static int pair(short s, short s2) {
        return s << 16 | s2 & 0xFFFF;
    }

    public static final int average(int n, int n2) {
        return (n & n2) + (n ^ n2) / 2;
    }

    public static int roundInt(double d) {
        return (int)(d < 0.0 ? (d == (double)((int)d) ? d : d - 1.0) : d);
    }

    public static int getPositiveId(int n) {
        if (n < 0) {
            return -n * 2 - 1;
        }
        return n * 2;
    }

    public static boolean isInteger(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        if (string.charAt(0) == '-') {
            if (n == 1) {
                return false;
            }
            n2 = 1;
        }
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c <= '/' || c >= ':') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static double getSD(int[] nArray, double d) {
        double d2 = 0.0;
        for (int n : nArray) {
            d2 += Math.pow(Math.abs((double)n - d), 2.0);
        }
        return Math.sqrt(d2 / (double)nArray.length);
    }

    static {
        for (int i = 0; i < ATAN2_DIM; ++i) {
            for (int j = 0; j < ATAN2_DIM; ++j) {
                float f = (float)i / (float)ATAN2_DIM;
                float f2 = (float)j / (float)ATAN2_DIM;
                MathMan.atan2[j * MathMan.ATAN2_DIM + i] = (float)Math.atan2(f2, f);
            }
        }
    }
}

