/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.annotations.annotations.Contract;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.ComponentLike;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.uuid.UUIDMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PlayerManager<P extends PlotPlayer<? extends T>, T> {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final Map<UUID, P> playerMap = new HashMap<UUID, P>();
    private final Object playerLock = new Object();

    public static void getUUIDsFromString(@NonNull String string, @NonNull BiConsumer<Collection<UUID>, Throwable> biConsumer) {
        String[] stringArray = string.split(",");
        HashSet<UUID> hashSet = new HashSet<UUID>();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : stringArray) {
            if (string2.isEmpty()) {
                biConsumer.accept(Collections.emptySet(), null);
                return;
            }
            if ("*".equals(string2)) {
                hashSet.add(DBFunc.EVERYONE);
                continue;
            }
            if (string2.length() > 16) {
                try {
                    hashSet.add(UUID.fromString(string2));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    biConsumer.accept(Collections.emptySet(), null);
                    return;
                }
            }
            linkedList.add(string2);
        }
        if (linkedList.isEmpty()) {
            biConsumer.accept(hashSet, null);
        } else {
            PlotSquared.get().getImpromptuUUIDPipeline().getUUIDs(linkedList, Settings.UUID.NON_BLOCKING_TIMEOUT).whenComplete((list, throwable) -> {
                if (throwable != null) {
                    biConsumer.accept((Collection<UUID>)null, (Throwable)throwable);
                } else {
                    for (UUIDMapping uUIDMapping : list) {
                        hashSet.add(uUIDMapping.uuid());
                    }
                    biConsumer.accept(hashSet, null);
                }
            });
        }
    }

    public static @NonNull Component getPlayerList(@NonNull Collection<UUID> collection, LocaleHolder localeHolder) {
        if (collection.isEmpty()) {
            return TranslatableCaption.of("info.none").toComponent(localeHolder).asComponent();
        }
        LinkedList<UUID> linkedList = new LinkedList<UUID>();
        LinkedList<Component> linkedList2 = new LinkedList<Component>();
        for (UUID object2 : collection) {
            if (object2 == null) {
                linkedList2.add(TranslatableCaption.of("info.none").toComponent(localeHolder));
                continue;
            }
            if (DBFunc.EVERYONE.equals(object2)) {
                linkedList2.add(TranslatableCaption.of("info.everyone").toComponent(localeHolder));
                continue;
            }
            if (DBFunc.SERVER.equals(object2)) {
                linkedList2.add(TranslatableCaption.of("info.console").toComponent(localeHolder));
                continue;
            }
            linkedList.add(object2);
        }
        try {
            for (UUIDMapping uUIDMapping : PlotSquared.get().getImpromptuUUIDPipeline().getNames(linkedList).get(Settings.UUID.BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS)) {
                linkedList2.add(Component.text(uUIDMapping.username()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Iterator<UUIDMapping> iterator = TranslatableCaption.of("info.plot_user_list").getComponent(ConsolePlayer.getConsole());
        TextComponent.Builder builder = Component.text();
        for (int i = 0; i < linkedList2.size(); ++i) {
            if (i + 1 == collection.size()) {
                builder.append(MINI_MESSAGE.deserialize((String)((Object)iterator), (TagResolver)TagResolver.resolver("user", Tag.inserting((ComponentLike)linkedList2.get(i)))));
                continue;
            }
            builder.append(MINI_MESSAGE.deserialize(iterator + ", ", (TagResolver)TagResolver.resolver("user", Tag.inserting((ComponentLike)linkedList2.get(i)))));
        }
        return builder.asComponent();
    }

    @Deprecated(since="7.1.0")
    public static @NonNull Caption resolveName(@Nullable UUID uUID) {
        return PlayerManager.resolveName(uUID, true);
    }

    @Deprecated(since="7.1.0")
    public static @NonNull Caption resolveName(@Nullable UUID uUID, boolean bl) {
        UUIDMapping uUIDMapping;
        if (uUID == null) {
            return TranslatableCaption.of("info.none");
        }
        if (uUID.equals(DBFunc.EVERYONE)) {
            return TranslatableCaption.of("info.everyone");
        }
        if (uUID.equals(DBFunc.SERVER)) {
            return TranslatableCaption.of("info.server");
        }
        String string = bl ? PlotSquared.get().getImpromptuUUIDPipeline().getSingle(uUID, Settings.UUID.BLOCKING_TIMEOUT) : ((uUIDMapping = PlotSquared.get().getImpromptuUUIDPipeline().getImmediately(uUID)) != null ? uUIDMapping.username() : null);
        if (string == null) {
            return TranslatableCaption.of("info.unknown");
        }
        return StaticCaption.of(string);
    }

    @Contract(value="_->!null")
    public @NonNull CompletableFuture<Caption> getUsernameCaption(@Nullable UUID uUID) {
        if (uUID == null) {
            return CompletableFuture.completedFuture(TranslatableCaption.of("info.none"));
        }
        if (uUID.equals(DBFunc.EVERYONE)) {
            return CompletableFuture.completedFuture(TranslatableCaption.of("info.everyone"));
        }
        if (uUID.equals(DBFunc.SERVER)) {
            return CompletableFuture.completedFuture(TranslatableCaption.of("info.server"));
        }
        P p = this.getPlayerIfExists(uUID);
        if (p != null) {
            return CompletableFuture.completedFuture(StaticCaption.of(p.getName()));
        }
        return PlotSquared.get().getImpromptuUUIDPipeline().getNames(Collections.singleton(uUID)).thenApply(list -> {
            if (list.isEmpty()) {
                return TranslatableCaption.of("info.unknown");
            }
            return StaticCaption.of(((UUIDMapping)list.get(0)).username());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(@NonNull PlotPlayer<?> plotPlayer) {
        Object object = this.playerLock;
        synchronized (object) {
            this.playerMap.remove(plotPlayer.getUUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(@NonNull UUID uUID) {
        Object object = this.playerLock;
        synchronized (object) {
            this.playerMap.remove(uUID);
        }
    }

    public @Nullable P getPlayerIfExists(@Nullable UUID uUID) {
        if (uUID == null) {
            return null;
        }
        return (P)((PlotPlayer)this.playerMap.get(uUID));
    }

    public @Nullable P getPlayerIfExists(@Nullable String string) {
        for (PlotPlayer plotPlayer : this.playerMap.values()) {
            if (!plotPlayer.getName().equalsIgnoreCase(string)) continue;
            return (P)plotPlayer;
        }
        return null;
    }

    public abstract @NonNull P getPlayer(@NonNull T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull P getPlayer(@NonNull UUID uUID) {
        Object object = this.playerLock;
        synchronized (object) {
            PlotPlayer plotPlayer = (PlotPlayer)this.playerMap.get(uUID);
            if (plotPlayer == null) {
                plotPlayer = this.createPlayer(uUID);
                this.playerMap.put(uUID, plotPlayer);
            }
            return (P)plotPlayer;
        }
    }

    public abstract @NonNull P createPlayer(@NonNull UUID var1);

    public abstract @Nullable OfflinePlotPlayer getOfflinePlayer(@Nullable UUID var1);

    public abstract @Nullable OfflinePlotPlayer getOfflinePlayer(@NonNull String var1);

    public Collection<P> getPlayers() {
        return Collections.unmodifiableCollection(new ArrayList<P>(this.playerMap.values()));
    }

    public static final class NoSuchPlayerException
    extends IllegalArgumentException {
        public NoSuchPlayerException(@NonNull UUID uUID) {
            super(String.format("There is no online player with UUID '%s'", uUID));
        }
    }
}

