/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.prtree.MBRConverter;
import com.sk89q.worldedit.regions.CuboidRegion;

public class PlotAreaConverter
implements MBRConverter<PlotArea> {
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;

    @Override
    public int getDimensions() {
        return 3;
    }

    @Override
    public double getMin(int n, PlotArea plotArea) {
        CuboidRegion cuboidRegion = plotArea.getRegion();
        if (n == 0) {
            return cuboidRegion.getMinimumPoint().getX();
        }
        if (n == 1) {
            return cuboidRegion.getMinimumPoint().getY();
        }
        if (n == 2) {
            return cuboidRegion.getMinimumPoint().getZ();
        }
        throw new IllegalArgumentException("Unknown axis: " + n);
    }

    @Override
    public double getMax(int n, PlotArea plotArea) {
        CuboidRegion cuboidRegion = plotArea.getRegion();
        if (n == 0) {
            return cuboidRegion.getMaximumPoint().getX();
        }
        if (n == 1) {
            return cuboidRegion.getMaximumPoint().getY();
        }
        if (n == 2) {
            return cuboidRegion.getMaximumPoint().getZ();
        }
        throw new IllegalArgumentException("Unknown axis: " + n);
    }
}

