/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.arkitektonika.Arkitektonika;
import com.plotsquared.core.arkitektonika.SchematicKeys;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.google.Inject;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.Tag;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlotUploader {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotUploader.class.getSimpleName()));
    private static final Path TEMP_DIR = Paths.get(PlotSquared.platform().getDirectory().getPath(), new String[0]);
    private final SchematicHandler schematicHandler;
    private final Arkitektonika arkitektonika;

    @Inject
    public PlotUploader(@NonNull SchematicHandler schematicHandler) {
        this.schematicHandler = schematicHandler;
        this.arkitektonika = Arkitektonika.builder().withUrl(Settings.Arkitektonika.BACKEND_URL).build();
    }

    public CompletableFuture<PlotUploadResult> upload(@NonNull Plot plot) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.schematicHandler.getCompoundTag(plot).handle((compoundTag, throwable) -> {
            plot.removeRunning();
            return compoundTag;
        })).thenApply(this::writeToTempFile)).thenApply(this::uploadAndDelete)).thenApply(this::wrapIntoResult);
    }

    private @NonNull PlotUploadResult wrapIntoResult(@Nullable SchematicKeys schematicKeys) {
        if (schematicKeys == null) {
            return PlotUploadResult.failed();
        }
        String string = Settings.Arkitektonika.DOWNLOAD_URL.replace("{key}", schematicKeys.getAccessKey());
        String string2 = Settings.Arkitektonika.DELETE_URL.replace("{key}", schematicKeys.getDeletionKey());
        return PlotUploadResult.success(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable SchematicKeys uploadAndDelete(@NonNull Path path) {
        try {
            CompletableFuture<SchematicKeys> completableFuture = this.arkitektonika.upload(path.toFile());
            SchematicKeys schematicKeys = completableFuture.join();
            return schematicKeys;
        }
        catch (CompletionException completionException) {
            LOGGER.error("Failed to upload schematic", (Throwable)completionException);
            SchematicKeys schematicKeys = null;
            return schematicKeys;
        }
        finally {
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                LOGGER.error("Failed to delete temporary file {}", (Object)path, (Object)iOException);
            }
        }
    }

    private @NonNull Path writeToTempFile(@NonNull CompoundTag compoundTag) {
        try {
            Path path = Files.createTempFile(TEMP_DIR, null, null, new FileAttribute[0]);
            try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                this.writeSchematic(compoundTag, outputStream);
            }
            return path;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void writeSchematic(@NonNull CompoundTag compoundTag, @NonNull OutputStream outputStream) {
        try (NBTOutputStream nBTOutputStream = new NBTOutputStream((OutputStream)new GZIPOutputStream(outputStream));){
            nBTOutputStream.writeNamedTag("Schematic", (Tag)compoundTag);
        }
    }

    public static class PlotUploadResult {
        private final boolean success;
        private final String downloadUrl;
        private final String deletionUrl;

        private PlotUploadResult(boolean bl, @Nullable String string, @Nullable String string2) {
            this.success = bl;
            this.downloadUrl = string;
            this.deletionUrl = string2;
        }

        private static @NonNull PlotUploadResult success(@NonNull String string, @Nullable String string2) {
            return new PlotUploadResult(true, string, string2);
        }

        private static @NonNull PlotUploadResult failed() {
            return new PlotUploadResult(false, null, null);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public String getDeletionUrl() {
            return this.deletionUrl;
        }
    }
}

