/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.queue.BasicQueueCoordinator;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RegionManager {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + RegionManager.class.getSimpleName()));
    public static RegionManager manager = null;
    protected final WorldUtil worldUtil;
    private final GlobalBlockQueue blockQueue;
    private final ProgressSubscriberFactory subscriberFactory;

    @Inject
    public RegionManager(@NonNull WorldUtil worldUtil, @NonNull GlobalBlockQueue globalBlockQueue, @NonNull ProgressSubscriberFactory progressSubscriberFactory) {
        this.worldUtil = worldUtil;
        this.blockQueue = globalBlockQueue;
        this.subscriberFactory = progressSubscriberFactory;
    }

    public static BlockVector2 getRegion(Location location) {
        int n = location.getX() >> 9;
        int n2 = location.getZ() >> 9;
        return BlockVector2.at((int)n, (int)n2);
    }

    public abstract int[] countEntities(Plot var1);

    public void deleteRegionFiles(String string, Collection<BlockVector2> collection, Runnable runnable) {
        TaskManager.runTaskAsync(() -> {
            for (BlockVector2 blockVector2 : collection) {
                String string2 = string + File.separator + "region" + File.separator + "r." + blockVector2.getX() + "." + blockVector2.getZ() + ".mca";
                File file = new File(PlotSquared.platform().worldContainer(), string2);
                LOGGER.info("- Deleting file: {} (max 1024 chunks)", (Object)file.getName());
                if (!file.exists()) continue;
                file.delete();
            }
            TaskManager.runTask(runnable);
        });
    }

    public boolean setCuboids(@NonNull PlotArea plotArea, @NonNull Set<CuboidRegion> set, @NonNull Pattern pattern, int n, int n2, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        boolean bl = false;
        if (queueCoordinator == null) {
            queueCoordinator = plotArea.getQueue();
            bl = true;
            if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                queueCoordinator.addProgressSubscriber(this.subscriberFactory.createWithActor(plotPlayer));
            }
        }
        for (CuboidRegion cuboidRegion : set) {
            Location location = Location.at(plotArea.getWorldName(), cuboidRegion.getMinimumPoint().getX(), n, cuboidRegion.getMinimumPoint().getZ());
            Location location2 = Location.at(plotArea.getWorldName(), cuboidRegion.getMaximumPoint().getX(), n2, cuboidRegion.getMaximumPoint().getZ());
            queueCoordinator.setCuboid(location, location2, pattern);
        }
        return !bl || queueCoordinator.enqueue();
    }

    public boolean notifyClear(PlotManager plotManager) {
        return false;
    }

    public abstract boolean handleClear(@NonNull Plot var1, @Nullable Runnable var2, @NonNull PlotManager var3, @Nullable PlotPlayer<?> var4);

    public boolean copyRegion(@NonNull Location location, @NonNull Location location2, @NonNull Location location3, @Nullable PlotPlayer<?> plotPlayer, @NonNull Runnable runnable) {
        int n = location3.getX() - location.getX();
        int n2 = location3.getZ() - location.getZ();
        World world = this.worldUtil.getWeWorld(location.getWorldName());
        World world2 = this.worldUtil.getWeWorld(location3.getWorldName());
        QueueCoordinator queueCoordinator = this.blockQueue.getNewQueue(world);
        BasicQueueCoordinator basicQueueCoordinator = (BasicQueueCoordinator)this.blockQueue.getNewQueue(world2);
        this.setCopyFromToConsumer(location, location2, n, n2, world, queueCoordinator, basicQueueCoordinator, false);
        queueCoordinator.setCompleteTask(basicQueueCoordinator::enqueue);
        if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            queueCoordinator.addProgressSubscriber(this.subscriberFactory.createFull(plotPlayer, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region_copy")));
        }
        queueCoordinator.addReadChunks(new CuboidRegion(BlockVector3.at((int)location.getX(), (int)0, (int)location.getZ()), BlockVector3.at((int)location2.getX(), (int)0, (int)location2.getZ())).getChunks());
        basicQueueCoordinator.setCompleteTask(runnable);
        if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            basicQueueCoordinator.addProgressSubscriber(this.subscriberFactory.createFull(plotPlayer, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region_paste")));
        }
        return queueCoordinator.enqueue();
    }

    public abstract boolean regenerateRegion(Location var1, Location var2, boolean var3, Runnable var4);

    public abstract void clearAllEntities(Location var1, Location var2);

    public void swap(Location location, Location location2, Location location3, @Nullable PlotPlayer<?> plotPlayer, Runnable runnable) {
        int n = location3.getX() - location.getX();
        int n2 = location3.getZ() - location.getZ();
        World world = this.worldUtil.getWeWorld(location.getWorldName());
        World world2 = this.worldUtil.getWeWorld(location3.getWorldName());
        QueueCoordinator queueCoordinator = this.blockQueue.getNewQueue(world);
        QueueCoordinator queueCoordinator2 = this.blockQueue.getNewQueue(world2);
        queueCoordinator.setUnloadAfter(false);
        queueCoordinator2.setUnloadAfter(false);
        queueCoordinator.addReadChunks(new CuboidRegion(location.getBlockVector3(), location2.getBlockVector3()).getChunks());
        queueCoordinator2.addReadChunks(new CuboidRegion(location3.getBlockVector3(), BlockVector3.at((int)(location3.getX() + location2.getX() - location.getX()), (int)location.getY(), (int)(location3.getZ() + location2.getZ() - location.getZ()))).getChunks());
        QueueCoordinator queueCoordinator3 = this.blockQueue.getNewQueue(world);
        QueueCoordinator queueCoordinator4 = this.blockQueue.getNewQueue(world2);
        this.setCopyFromToConsumer(location, location2, n, n2, world, queueCoordinator, queueCoordinator4, true);
        this.setCopyFromToConsumer(location.add(n, 0, n2), location2.add(n, 0, n2), -n, -n2, world, queueCoordinator2, queueCoordinator3, true);
        queueCoordinator4.setCompleteTask(runnable);
        if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            queueCoordinator4.addProgressSubscriber(this.subscriberFactory.createFull(plotPlayer, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region2_paste")));
        }
        queueCoordinator3.setCompleteTask(queueCoordinator4::enqueue);
        if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            queueCoordinator3.addProgressSubscriber(this.subscriberFactory.createFull(plotPlayer, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region1_paste")));
        }
        queueCoordinator2.setCompleteTask(queueCoordinator3::enqueue);
        if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            queueCoordinator2.addProgressSubscriber(this.subscriberFactory.createFull(plotPlayer, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region2_copy")));
        }
        queueCoordinator.setCompleteTask(queueCoordinator2::enqueue);
        if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            queueCoordinator.addProgressSubscriber(this.subscriberFactory.createFull(plotPlayer, Settings.QUEUE.NOTIFY_INTERVAL, Settings.QUEUE.NOTIFY_WAIT, TranslatableCaption.of("swap.progress_region1_copy")));
        }
        queueCoordinator.enqueue();
    }

    private void setCopyFromToConsumer(Location location, Location location2, int n, int n2, World world, QueueCoordinator queueCoordinator, QueueCoordinator queueCoordinator2, boolean bl) {
        queueCoordinator.setChunkConsumer(blockVector2 -> {
            int n3 = blockVector2.getX();
            int n4 = blockVector2.getZ();
            int n5 = n3 << 4;
            int n6 = n4 << 4;
            int n7 = Math.max(location.getX(), n5) & 0xF;
            int n8 = Math.max(location.getZ(), n6) & 0xF;
            int n9 = Math.min(location2.getX(), n5 + 15) & 0xF;
            int n10 = Math.min(location2.getZ(), n6 + 15) & 0xF;
            for (int i = world.getMinY(); i <= world.getMaxY(); ++i) {
                for (int j = n7; j <= n9; ++j) {
                    for (int k = n8; k <= n10; ++k) {
                        int n11 = n5 + j;
                        int n12 = n6 + k;
                        BlockVector3 blockVector3 = BlockVector3.at((int)n11, (int)i, (int)n12);
                        queueCoordinator2.setBlock(n11 + n, i, n12 + n2, world.getFullBlock(blockVector3));
                        queueCoordinator2.setBiome(n11 + n, i, n12 + n2, world.getBiome(blockVector3));
                    }
                }
            }
            CuboidRegion cuboidRegion = new CuboidRegion(BlockVector3.at((int)(n5 + n7), (int)world.getMinY(), (int)(n6 + n8)), BlockVector3.at((int)(n5 + n9), (int)world.getMaxY(), (int)(n6 + n10)));
            queueCoordinator2.addEntities(world.getEntities((Region)cuboidRegion));
            if (bl) {
                for (Entity entity : world.getEntities((Region)cuboidRegion)) {
                    entity.remove();
                }
            }
        });
    }

    public void setBiome(CuboidRegion cuboidRegion, int n, BiomeType biomeType, PlotArea plotArea, Runnable runnable) {
        QueueCoordinator queueCoordinator = this.blockQueue.getNewQueue(this.worldUtil.getWeWorld(plotArea.getWorldName()));
        queueCoordinator.addReadChunks(cuboidRegion.getChunks());
        BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
        BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
        queueCoordinator.setChunkConsumer(blockVector2 -> {
            BlockVector3 blockVector33 = BlockVector3.at((int)Math.max(blockVector2.getX() << 4, blockVector3.getBlockX()), (int)blockVector3.getBlockY(), (int)Math.max(blockVector2.getZ() << 4, blockVector3.getBlockZ()));
            BlockVector3 blockVector34 = BlockVector3.at((int)Math.min((blockVector2.getX() << 4) + 15, blockVector32.getBlockX()), (int)blockVector32.getBlockY(), (int)Math.min((blockVector2.getZ() << 4) + 15, blockVector32.getBlockZ()));
            CuboidRegion cuboidRegion2 = new CuboidRegion(cuboidRegion.getWorld(), blockVector33, blockVector34);
            WorldUtil.setBiome(plotArea.getWorldName(), cuboidRegion2, biomeType);
            this.worldUtil.refreshChunk(blockVector2.getBlockX(), blockVector2.getBlockZ(), plotArea.getWorldName());
        });
        queueCoordinator.setCompleteTask(runnable);
        queueCoordinator.enqueue();
    }
}

