/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.util.StringMan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;

public class StringComparison<T> {
    private final Function<T, String> toString;
    private T bestMatch;
    private double match = 2.147483647E9;
    private T bestMatchObject;

    public StringComparison(String string, T[] TArray) {
        this(string, TArray, Object::toString);
    }

    public StringComparison(String string, T[] TArray, Function<T, String> function) {
        this.toString = function;
        this.init(string, TArray);
    }

    public StringComparison(String string, Collection<T> collection) {
        this(string, collection, Object::toString);
    }

    public StringComparison(String string, Collection<T> collection, Function<T, String> function) {
        this(string, collection.toArray(), function);
    }

    public StringComparison() {
        this.toString = Object::toString;
    }

    public static int compare(String string, String string2) {
        int n = StringMan.getLevenshteinDistance(string, string2);
        if (string2.contains(string)) {
            n -= Math.min(string.length(), string2.length());
        }
        if (string2.startsWith(string)) {
            n -= 4;
        }
        return n;
    }

    public static ArrayList<String> wLetterPair(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.split("\\s")) {
            String[] stringArray2 = StringComparison.sLetterPair(string2);
            Collections.addAll(arrayList, stringArray2);
        }
        return arrayList;
    }

    public static String[] sLetterPair(String string) {
        int n = string.length() - 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(i, i + 2);
        }
        return stringArray;
    }

    public void init(String string, T[] TArray) {
        this.bestMatch = TArray[0];
        this.bestMatchObject = TArray[0];
        string = string.toLowerCase();
        for (T t : TArray) {
            int n;
            int n2 = StringComparison.compare(string, this.getString(t).toLowerCase());
            if (!((double)n < this.match)) continue;
            this.match = n2;
            this.bestMatch = t;
            this.bestMatchObject = t;
        }
    }

    public String getString(T t) {
        return this.toString.apply(t);
    }

    public T getMatchObject() {
        return this.bestMatchObject;
    }

    public String getBestMatch() {
        return this.getString(this.bestMatch);
    }

    public ComparisonResult getBestMatchAdvanced() {
        return new ComparisonResult(this.match, this.bestMatch);
    }

    public class ComparisonResult {
        public final T best;
        public final double match;

        public ComparisonResult(double d, T t) {
            this.match = d;
            this.best = t;
        }
    }
}

