/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.placeholders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.placeholders.Placeholder;
import com.plotsquared.core.util.placeholders.PlotFlagPlaceholder;
import com.plotsquared.core.util.placeholders.PlotSpecificPlaceholder;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Singleton;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public final class PlaceholderRegistry {
    private final Map<String, Placeholder> placeholders = Maps.newHashMap();
    private final EventDispatcher eventDispatcher;

    @Inject
    public PlaceholderRegistry(@NonNull EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        this.registerDefault();
    }

    private static String legacyComponent(TranslatableCaption translatableCaption, LocaleHolder localeHolder) {
        return PlotSquared.platform().toLegacyPlatformString(translatableCaption.toComponent(localeHolder).asComponent());
    }

    private void registerDefault() {
        GlobalFlagContainer globalFlagContainer = GlobalFlagContainer.getInstance();
        for (PlotFlag<?, ?> plotFlag2 : globalFlagContainer.getRecognizedPlotFlags()) {
            this.registerPlaceholder(new PlotFlagPlaceholder(plotFlag2, true));
            this.registerPlaceholder(new PlotFlagPlaceholder(plotFlag2, false));
        }
        GlobalFlagContainer.getInstance().subscribe((plotFlag, plotFlagUpdateType) -> {
            this.registerPlaceholder(new PlotFlagPlaceholder(plotFlag, true));
            this.registerPlaceholder(new PlotFlagPlaceholder(plotFlag, false));
        });
        this.createPlaceholder("world_name", plotPlayer -> plotPlayer.getLocation().getWorldName());
        this.createPlaceholder("has_plot", plotPlayer -> plotPlayer.getPlotCount() > 0 ? "true" : "false");
        this.createPlaceholder("allowed_plot_count", plotPlayer -> {
            if (plotPlayer.getAllowedPlots() >= Integer.MAX_VALUE) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.infinite"), plotPlayer);
            }
            return Integer.toString(plotPlayer.getAllowedPlots());
        });
        this.createPlaceholder("plot_count", plotPlayer -> Integer.toString(plotPlayer.getPlotCount()));
        this.createPlaceholder("currentplot_alias", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (plot.getAlias().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), plotPlayer);
            }
            return plot.getAlias();
        });
        this.createPlaceholder("currentplot_owner", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.server"), plotPlayer);
            }
            UUID uUID = plot.getOwnerAbs();
            if (uUID == null) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("generic.generic_unowned"), plotPlayer);
            }
            try {
                return PlotSquared.platform().playerManager().getUsernameCaption(uUID).get(Settings.UUID.BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS).getComponent((LocaleHolder)plotPlayer);
            }
            catch (Exception exception) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.unknown"), plotPlayer);
            }
        });
        this.createPlaceholder("currentplot_members", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (plot.getMembers().isEmpty() && plot.getTrusted().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), plotPlayer);
            }
            return String.valueOf(plot.getMembers().size() + plot.getTrusted().size());
        });
        this.createPlaceholder("currentplot_members_added", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (plot.getMembers().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), plotPlayer);
            }
            return String.valueOf(plot.getMembers().size());
        });
        this.createPlaceholder("currentplot_members_trusted", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (plot.getTrusted().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), plotPlayer);
            }
            return String.valueOf(plot.getTrusted().size());
        });
        this.createPlaceholder("currentplot_members_denied", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (plot.getDenied().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), plotPlayer);
            }
            return String.valueOf(plot.getDenied().size());
        });
        this.createPlaceholder("currentplot_members_trusted_list", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (plot.getTrusted().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), plotPlayer);
            }
            return PlotSquared.platform().toLegacyPlatformString(PlayerManager.getPlayerList(plot.getTrusted(), plotPlayer));
        });
        this.createPlaceholder("currentplot_members_added_list", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (plot.getMembers().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), plotPlayer);
            }
            return PlotSquared.platform().toLegacyPlatformString(PlayerManager.getPlayerList(plot.getMembers(), plotPlayer));
        });
        this.createPlaceholder("currentplot_members_denied_list", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (plot.getDenied().isEmpty()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.none"), plotPlayer);
            }
            return PlotSquared.platform().toLegacyPlatformString(PlayerManager.getPlayerList(plot.getDenied(), plotPlayer));
        });
        this.createPlaceholder("currentplot_creationdate", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (plot.getTimestamp() == 0L || !plot.hasOwner()) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("info.unknown"), plotPlayer);
            }
            long l = plot.getTimestamp();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Settings.Timeformat.DATE_FORMAT);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(Settings.Timeformat.TIME_ZONE));
            return simpleDateFormat.format(l);
        });
        this.createPlaceholder("currentplot_can_build", (PlotPlayer<?> plotPlayer, Plot plot) -> plot.isAdded(plotPlayer.getUUID()) ? "true" : "false");
        this.createPlaceholder("currentplot_x", (PlotPlayer<?> plotPlayer, Plot plot) -> Integer.toString(plot.getId().getX()));
        this.createPlaceholder("currentplot_y", (PlotPlayer<?> plotPlayer, Plot plot) -> Integer.toString(plot.getId().getY()));
        this.createPlaceholder("currentplot_xy", (PlotPlayer<?> plotPlayer, Plot plot) -> plot.getId().toString());
        this.createPlaceholder("currentplot_rating", (PlotPlayer<?> plotPlayer, Plot plot) -> {
            if (Double.isNaN(plot.getAverageRating())) {
                return PlaceholderRegistry.legacyComponent(TranslatableCaption.of("placeholder.nan"), plotPlayer);
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(plot.getAverageRating()).setScale(2, RoundingMode.HALF_UP);
            if (!Settings.General.SCIENTIFIC) {
                return String.valueOf(bigDecimal);
            }
            return Double.toString(plot.getAverageRating());
        });
        this.createPlaceholder("currentplot_biome", (PlotPlayer<?> plotPlayer, Plot plot) -> plot.getBiomeSynchronous().toString());
        this.createPlaceholder("currentplot_size", (PlotPlayer<?> plotPlayer, Plot plot) -> String.valueOf(plot.getConnectedPlots().size()));
    }

    public void createPlaceholder(@NonNull String string, final @NonNull Function<PlotPlayer<?>, String> function) {
        this.registerPlaceholder(new Placeholder(string){

            @Override
            public @NonNull String getValue(@NonNull PlotPlayer<?> plotPlayer) {
                return (String)function.apply(plotPlayer);
            }
        });
    }

    public void createPlaceholder(@NonNull String string, final @NonNull BiFunction<PlotPlayer<?>, Plot, String> biFunction) {
        this.registerPlaceholder(new PlotSpecificPlaceholder(string){

            @Override
            public @NonNull String getValue(@NonNull PlotPlayer<?> plotPlayer, @NonNull Plot plot) {
                return (String)biFunction.apply(plotPlayer, plot);
            }
        });
    }

    public void registerPlaceholder(@NonNull Placeholder placeholder) {
        Placeholder placeholder2 = this.placeholders.put(placeholder.getKey().toLowerCase(Locale.ENGLISH), (Placeholder)Preconditions.checkNotNull((Object)placeholder, (Object)"Placeholder may not be null"));
        if (placeholder2 == null) {
            this.eventDispatcher.callGenericEvent(new PlaceholderAddedEvent(placeholder));
        }
    }

    public @Nullable Placeholder getPlaceholder(@NonNull String string) {
        return this.placeholders.get(((String)Preconditions.checkNotNull((Object)string, (Object)"Key may not be null")).toLowerCase(Locale.ENGLISH));
    }

    public @NonNull String getPlaceholderValue(@NonNull String string, @NonNull PlotPlayer<?> plotPlayer) {
        Placeholder placeholder = this.getPlaceholder(string);
        if (placeholder == null) {
            return "";
        }
        String string2 = "";
        try {
            string2 = placeholder.getValue(plotPlayer);
            if (string2 == null) {
                new RuntimeException(String.format("Placeholder '%s' returned null for player '%s'", placeholder.getKey(), plotPlayer.getName())).printStackTrace();
            }
        }
        catch (Exception exception) {
            new RuntimeException(String.format("Placeholder '%s' failed to evalulate for player '%s'", placeholder.getKey(), plotPlayer.getName()), exception).printStackTrace();
        }
        return string2;
    }

    public @NonNull Collection<Placeholder> getPlaceholders() {
        return Collections.unmodifiableCollection(this.placeholders.values());
    }

    public record PlaceholderAddedEvent(Placeholder placeholder) {
    }
}

