/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.query;

import com.google.common.base.Preconditions;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.Rating;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.query.AliasFilter;
import com.plotsquared.core.util.query.AreaLimitedPlotProvider;
import com.plotsquared.core.util.query.ExpiredPlotProvider;
import com.plotsquared.core.util.query.FixedPlotProvider;
import com.plotsquared.core.util.query.GlobalPlotProvider;
import com.plotsquared.core.util.query.MemberFilter;
import com.plotsquared.core.util.query.NullProvider;
import com.plotsquared.core.util.query.OwnerFilter;
import com.plotsquared.core.util.query.OwnersIncludeFilter;
import com.plotsquared.core.util.query.PaginatedPlotResult;
import com.plotsquared.core.util.query.PlotFilter;
import com.plotsquared.core.util.query.PlotProvider;
import com.plotsquared.core.util.query.PredicateFilter;
import com.plotsquared.core.util.query.SearchPlotProvider;
import com.plotsquared.core.util.query.SortingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlotQuery
implements Iterable<Plot> {
    private final Collection<PlotFilter> filters = new LinkedList<PlotFilter>();
    private final PlotAreaManager plotAreaManager;
    private PlotProvider plotProvider;
    private SortingStrategy sortingStrategy = SortingStrategy.NO_SORTING;
    private PlotArea priorityArea;
    private Comparator<Plot> plotComparator;

    private PlotQuery(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
        this.plotProvider = new GlobalPlotProvider(plotAreaManager);
    }

    public static PlotQuery newQuery() {
        return new PlotQuery(PlotSquared.get().getPlotAreaManager());
    }

    public @NonNull PlotQuery inArea(@NonNull PlotArea plotArea) {
        Preconditions.checkNotNull((Object)plotArea, (Object)"Area may not be null");
        this.plotProvider = new AreaLimitedPlotProvider(Collections.singletonList(plotArea));
        return this;
    }

    public @NonNull PlotQuery inWorld(@NonNull String string) {
        Preconditions.checkNotNull((Object)string, (Object)"World may not be null");
        this.plotProvider = new AreaLimitedPlotProvider(this.plotAreaManager.getPlotAreasSet(string));
        return this;
    }

    public @NonNull PlotQuery inAreas(@NonNull Collection<PlotArea> collection) {
        Preconditions.checkNotNull(collection, (Object)"Areas may not be null");
        Preconditions.checkState((!collection.isEmpty() ? 1 : 0) != 0, (Object)"At least one area must be provided");
        this.plotProvider = new AreaLimitedPlotProvider(Collections.unmodifiableCollection(collection));
        return this;
    }

    public @NonNull PlotQuery expiredPlots() {
        this.plotProvider = new ExpiredPlotProvider();
        return this;
    }

    public @NonNull PlotQuery allPlots() {
        this.plotProvider = new GlobalPlotProvider(this.plotAreaManager);
        return this;
    }

    public @NonNull PlotQuery noPlots() {
        this.plotProvider = new NullProvider();
        return this;
    }

    public @NonNull PlotQuery plotsBySearch(@NonNull String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Search term may not be null");
        this.plotProvider = new SearchPlotProvider(string);
        return this;
    }

    public @NonNull PlotQuery withPlot(@NonNull Plot plot) {
        Preconditions.checkNotNull((Object)plot, (Object)"Plot may not be null");
        this.plotProvider = new FixedPlotProvider(plot);
        return this;
    }

    public @NonNull PlotQuery whereBasePlot() {
        return this.addFilter(new PredicateFilter(Plot::isBasePlot));
    }

    public @NonNull PlotQuery ownedBy(@NonNull UUID uUID) {
        Preconditions.checkNotNull((Object)uUID, (Object)"Owner may not be null");
        return this.addFilter(new OwnerFilter(uUID));
    }

    public @NonNull PlotQuery ownedBy(@NonNull PlotPlayer<?> plotPlayer) {
        Preconditions.checkNotNull(plotPlayer, (Object)"Owner may not be null");
        return this.addFilter(new OwnerFilter(plotPlayer.getUUID()));
    }

    public @NonNull PlotQuery ownersInclude(@NonNull UUID uUID) {
        Preconditions.checkNotNull((Object)uUID, (Object)"Owner may not be null");
        return this.addFilter(new OwnersIncludeFilter(uUID));
    }

    public @NonNull PlotQuery ownersInclude(@NonNull PlotPlayer<?> plotPlayer) {
        Preconditions.checkNotNull(plotPlayer, (Object)"Owner may not be null");
        return this.addFilter(new OwnersIncludeFilter(plotPlayer.getUUID()));
    }

    public @NonNull PlotQuery withAlias(@NonNull String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Alias may not be null");
        return this.addFilter(new AliasFilter(string));
    }

    public @NonNull PlotQuery withMember(@NonNull UUID uUID) {
        Preconditions.checkNotNull((Object)uUID, (Object)"Member may not be null");
        return this.addFilter(new MemberFilter(uUID));
    }

    public @NonNull PlotQuery thatPasses(@NonNull Predicate<Plot> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"Predicate may not be null");
        return this.addFilter(new PredicateFilter(predicate));
    }

    public @NonNull PlotQuery withSortingStrategy(@NonNull SortingStrategy sortingStrategy) {
        Preconditions.checkNotNull((Object)((Object)sortingStrategy), (Object)"Strategy may not be null");
        this.sortingStrategy = sortingStrategy;
        return this;
    }

    public @NonNull PlotQuery sorted(@NonNull Comparator<Plot> comparator) {
        Preconditions.checkNotNull(comparator, (Object)"Comparator may not be null");
        this.sortingStrategy = SortingStrategy.COMPARATOR;
        this.plotComparator = comparator;
        return this;
    }

    public @NonNull PlotQuery relativeToArea(@NonNull PlotArea plotArea) {
        Preconditions.checkNotNull((Object)plotArea, (Object)"Area may not be null");
        this.priorityArea = plotArea;
        return this;
    }

    public @NonNull Stream<Plot> asStream() {
        return this.asList().stream();
    }

    public @NonNull List<Plot> asList() {
        ArrayList<Plot> arrayList;
        if (this.filters.isEmpty()) {
            arrayList = new ArrayList<Plot>(this.plotProvider.getPlots());
        } else {
            Collection<Plot> collection = this.plotProvider.getPlots();
            arrayList = new ArrayList(collection.size());
            block0: for (Plot plot3 : collection) {
                for (PlotFilter plotFilter : this.filters) {
                    if (plotFilter.accepts(plot3)) continue;
                    continue block0;
                }
                arrayList.add(plot3);
            }
        }
        if (this.sortingStrategy == SortingStrategy.NO_SORTING) {
            return arrayList;
        }
        if (this.sortingStrategy == SortingStrategy.SORT_BY_TEMP) {
            return PlotSquared.get().sortPlotsByTemp(arrayList);
        }
        if (this.sortingStrategy == SortingStrategy.SORT_BY_DONE) {
            arrayList.sort((plot, plot2) -> {
                String string = (String)plot.getFlag(DoneFlag.class);
                String string2 = (String)plot2.getFlag(DoneFlag.class);
                if (MathMan.isInteger(string)) {
                    if (MathMan.isInteger(string2)) {
                        return Integer.parseInt(string2) - Integer.parseInt(string);
                    }
                    return -1;
                }
                return 1;
            });
        } else if (this.sortingStrategy == SortingStrategy.SORT_BY_RATING) {
            arrayList.sort((plot, plot2) -> {
                double d2 = 0.0;
                int n = plot.getSettings().getRatings().size();
                int n2 = plot2.getRatings().size();
                if (!plot.getSettings().getRatings().isEmpty()) {
                    d2 = plot.getRatings().values().stream().mapToDouble(Rating::getAverageRating).map(d -> d * d).sum();
                    d2 /= (double)n;
                    d2 += (double)n;
                }
                double d3 = 0.0;
                if (!plot2.getSettings().getRatings().isEmpty()) {
                    for (Map.Entry<UUID, Rating> entry : plot2.getRatings().entrySet()) {
                        double d4 = entry.getValue().getAverageRating();
                        d3 += d4 * d4;
                    }
                    d3 /= (double)n2;
                    d3 += (double)n2;
                }
                if (d3 == d2 && d3 != 0.0) {
                    return n2 - n;
                }
                return (int)Math.signum(d3 - d2);
            });
        } else {
            if (this.sortingStrategy == SortingStrategy.SORT_BY_CREATION) {
                return PlotSquared.get().sortPlots(arrayList, PlotSquared.SortType.CREATION_DATE, this.priorityArea);
            }
            if (this.sortingStrategy == SortingStrategy.COMPARATOR) {
                arrayList.sort(this.plotComparator);
            }
        }
        return arrayList;
    }

    public @NonNull Set<Plot> asSet() {
        return new HashSet<Plot>(this.asList());
    }

    public @NonNull PaginatedPlotResult getPaginated(int n) {
        Preconditions.checkState((n > 0 ? 1 : 0) != 0, (Object)"Page size must be greater than 0");
        return new PaginatedPlotResult(this.asList(), n);
    }

    public @NonNull Collection<Plot> asCollection() {
        return this.asList();
    }

    public int count() {
        return this.asList().size();
    }

    public boolean anyMatch() {
        if (this.filters.isEmpty()) {
            return !this.plotProvider.getPlots().isEmpty();
        }
        Collection<Plot> collection = this.plotProvider.getPlots();
        block0: for (Plot plot : collection) {
            for (PlotFilter plotFilter : this.filters) {
                if (plotFilter.accepts(plot)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private @NonNull PlotQuery addFilter(@NonNull PlotFilter plotFilter) {
        this.filters.add(plotFilter);
        return this;
    }

    @Override
    public @NonNull Iterator<Plot> iterator() {
        return this.asCollection().iterator();
    }
}

