/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.uuid;

import com.google.common.collect.Lists;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.util.ThreadUtils;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.uuid.ServiceError;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UUIDPipeline {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + UUIDPipeline.class.getSimpleName()));
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private final Executor executor;
    private final List<UUIDService> serviceList;
    private final List<Consumer<List<UUIDMapping>>> consumerList;

    public UUIDPipeline(@NonNull Executor executor) {
        this.executor = executor;
        this.serviceList = Lists.newLinkedList();
        this.consumerList = Lists.newLinkedList();
    }

    public void registerService(@NonNull UUIDService uUIDService) {
        this.serviceList.add(uUIDService);
    }

    public void registerConsumer(@NonNull Consumer<@NonNull List<@NonNull UUIDMapping>> consumer) {
        this.consumerList.add(consumer);
    }

    public @NonNull List<@NonNull UUIDService> getServiceListInstance() {
        return Collections.unmodifiableList(this.serviceList);
    }

    public void consume(@NonNull List<@NonNull UUIDMapping> list) {
        Runnable runnable = () -> {
            for (Consumer<List<UUIDMapping>> consumer : this.consumerList) {
                consumer.accept(list);
            }
        };
        if (PlotSquared.get().isMainThread(Thread.currentThread())) {
            TaskManager.runTaskAsync(runnable);
        } else {
            runnable.run();
        }
    }

    public void consume(@NonNull UUIDMapping uUIDMapping) {
        this.consume(Collections.singletonList(uUIDMapping));
    }

    public void storeImmediately(@NonNull String string, @NonNull UUID uUID) {
        this.consume(new UUIDMapping(uUID, string));
    }

    public @Nullable UUID getSingle(@NonNull String string, long l) {
        block4: {
            ThreadUtils.catchSync("Blocking UUID retrieval from the main thread");
            try {
                List<UUIDMapping> list = this.getUUIDs(Collections.singletonList(string)).get(l, TimeUnit.MILLISECONDS);
                if (list.size() == 1) {
                    return list.get(0).uuid();
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
            catch (TimeoutException timeoutException) {
                if (!Settings.DEBUG) break block4;
                LOGGER.warn("(UUID) Request for {} timed out. Rate limit.", (Object)string);
            }
        }
        return null;
    }

    public @Nullable String getSingle(@NonNull UUID uUID, long l) {
        block4: {
            ThreadUtils.catchSync("Blocking username retrieval from the main thread");
            try {
                List<UUIDMapping> list = this.getNames(Collections.singletonList(uUID)).get(l, TimeUnit.MILLISECONDS);
                if (list.size() == 1) {
                    return list.get(0).username();
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
            catch (TimeoutException timeoutException) {
                if (!Settings.DEBUG) break block4;
                LOGGER.warn("(UUID) Request for {} timed out. Rate limit.", (Object)uUID);
            }
        }
        return null;
    }

    public void getSingle(@NonNull String string, @NonNull BiConsumer<@Nullable UUID, @Nullable Throwable> biConsumer) {
        this.getUUIDs(Collections.singletonList(string)).orTimeout(Settings.UUID.NON_BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS).whenComplete((list, throwable) -> {
            if (throwable != null) {
                biConsumer.accept((UUID)null, (Throwable)throwable);
            } else if (!list.isEmpty()) {
                biConsumer.accept(((UUIDMapping)list.get(0)).uuid(), null);
            } else {
                biConsumer.accept(null, null);
            }
        });
    }

    public void getSingle(@NonNull UUID uUID, @NonNull BiConsumer<@Nullable String, @Nullable Throwable> biConsumer) {
        this.getNames(Collections.singletonList(uUID)).orTimeout(Settings.UUID.NON_BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS).whenComplete((list, throwable) -> {
            if (throwable != null) {
                biConsumer.accept((String)null, (Throwable)throwable);
            } else if (!list.isEmpty()) {
                biConsumer.accept(((UUIDMapping)list.get(0)).username(), null);
            } else {
                biConsumer.accept(null, null);
            }
        });
    }

    public @NonNull CompletableFuture<@NonNull List<@NonNull UUIDMapping>> getNames(@NonNull Collection<@NonNull UUID> collection, long l) {
        return this.getNames(collection).orTimeout(l, TimeUnit.MILLISECONDS);
    }

    public @NonNull CompletableFuture<List<UUIDMapping>> getUUIDs(@NonNull Collection<String> collection, long l) {
        return this.getUUIDs(collection).orTimeout(l, TimeUnit.MILLISECONDS);
    }

    public @NonNull CompletableFuture<@NonNull List<@NonNull UUIDMapping>> getNames(@NonNull Collection<@NonNull UUID> collection) {
        if (collection.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List<UUIDService> list = this.getServiceListInstance();
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(collection.size());
        ArrayList<UUID> arrayList2 = new ArrayList<UUID>(collection);
        for (UUIDService uUIDService : list) {
            if (!uUIDService.canBeSynchronous()) break;
            List<UUIDMapping> list2 = uUIDService.getNames(arrayList2);
            for (UUIDMapping uUIDMapping : list2) {
                arrayList2.remove(uUIDMapping.uuid());
            }
            arrayList.addAll(list2);
            if (!arrayList2.isEmpty()) continue;
            return CompletableFuture.completedFuture(arrayList);
        }
        return CompletableFuture.supplyAsync(() -> {
            for (Object object : list) {
                List<UUIDMapping> list4 = object.getNames(arrayList2);
                for (UUIDMapping uUIDMapping : list4) {
                    arrayList2.remove(uUIDMapping.uuid());
                }
                arrayList.addAll(list4);
                if (!arrayList2.isEmpty()) continue;
                break;
            }
            if (arrayList.size() == collection.size()) {
                this.consume(arrayList);
                return arrayList;
            }
            if (Settings.DEBUG) {
                LOGGER.info("(UUID) Failed to find all usernames");
            }
            if (Settings.UUID.UNKNOWN_AS_DEFAULT) {
                for (Object object : arrayList2) {
                    arrayList.add(new UUIDMapping((UUID)object, MINI_MESSAGE.escapeTags(TranslatableCaption.of("info.unknown").getComponent(ConsolePlayer.getConsole()))));
                }
                return arrayList;
            }
            throw new ServiceError("End of pipeline");
        }, this.executor);
    }

    public @NonNull CompletableFuture<@NonNull List<@NonNull UUIDMapping>> getUUIDs(@NonNull Collection<@NonNull String> collection) {
        if (collection.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List<UUIDService> list = this.getServiceListInstance();
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(collection.size());
        ArrayList<String> arrayList2 = new ArrayList<String>(collection);
        for (UUIDService uUIDService : list) {
            if (!uUIDService.canBeSynchronous()) break;
            List<UUIDMapping> list2 = uUIDService.getUUIDs(arrayList2);
            for (UUIDMapping uUIDMapping : list2) {
                arrayList2.remove(uUIDMapping.username());
            }
            arrayList.addAll(list2);
            if (!arrayList2.isEmpty()) continue;
            return CompletableFuture.completedFuture(arrayList);
        }
        return CompletableFuture.supplyAsync(() -> {
            for (UUIDService uUIDService : list) {
                List<UUIDMapping> list4 = uUIDService.getUUIDs(arrayList2);
                for (UUIDMapping uUIDMapping : list4) {
                    arrayList2.remove(uUIDMapping.username());
                }
                arrayList.addAll(list4);
                if (!arrayList2.isEmpty()) continue;
                break;
            }
            if (arrayList.size() == collection.size()) {
                this.consume(arrayList);
                return arrayList;
            }
            if (Settings.DEBUG) {
                LOGGER.info("(UUID) Failed to find all UUIDs");
            }
            throw new ServiceError("End of pipeline");
        }, this.executor);
    }

    public final @NonNull Collection<@NonNull UUIDMapping> getAllImmediately() {
        LinkedHashSet<UUIDMapping> linkedHashSet = new LinkedHashSet<UUIDMapping>();
        for (UUIDService uUIDService : this.getServiceListInstance()) {
            linkedHashSet.addAll(uUIDService.getImmediately());
        }
        return linkedHashSet;
    }

    public final @Nullable UUIDMapping getImmediately(@NonNull Object object) {
        for (UUIDService uUIDService : this.getServiceListInstance()) {
            UUIDMapping uUIDMapping = uUIDService.getImmediately(object);
            if (uUIDMapping == null) continue;
            return uUIDMapping;
        }
        return null;
    }
}

