/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.spi.Message;
import java.util.Collection;

public final class ConfigurationException
extends RuntimeException {
    private final ImmutableSet<Message> messages;
    private Object partialValue = null;
    private static final long serialVersionUID = 0L;

    public ConfigurationException(Iterable<Message> iterable) {
        this.messages = ImmutableSet.copyOf(iterable);
        this.initCause(Messages.getOnlyCause(this.messages));
    }

    public ConfigurationException withPartialValue(Object object) {
        Preconditions.checkState((this.partialValue == null ? 1 : 0) != 0, (String)"Can't clobber existing partial value %s with %s", (Object)this.partialValue, (Object)object);
        ConfigurationException configurationException = new ConfigurationException((Iterable<Message>)this.messages);
        configurationException.partialValue = object;
        return configurationException;
    }

    public Collection<Message> getErrorMessages() {
        return this.messages;
    }

    public <E> E getPartialValue() {
        return (E)this.partialValue;
    }

    @Override
    public String getMessage() {
        return Messages.formatMessages("Guice configuration errors", this.messages);
    }
}

