/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.plotsquared.google.Provider;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.MoreTypes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@CheckReturnValue
public class Key<T> {
    private final AnnotationStrategy annotationStrategy;
    private final TypeLiteral<T> typeLiteral;
    private final int hashCode;
    private String toString;

    protected Key(Class<? extends Annotation> clazz) {
        this.annotationStrategy = Key.strategyFor(clazz);
        this.typeLiteral = MoreTypes.canonicalizeForKey(TypeLiteral.fromSuperclassTypeParameter(this.getClass()));
        this.hashCode = this.computeHashCode();
    }

    protected Key(Annotation annotation) {
        this.annotationStrategy = Key.strategyFor(annotation);
        this.typeLiteral = MoreTypes.canonicalizeForKey(TypeLiteral.fromSuperclassTypeParameter(this.getClass()));
        this.hashCode = this.computeHashCode();
    }

    protected Key() {
        this.annotationStrategy = NullAnnotationStrategy.INSTANCE;
        this.typeLiteral = MoreTypes.canonicalizeForKey(TypeLiteral.fromSuperclassTypeParameter(this.getClass()));
        this.hashCode = this.computeHashCode();
    }

    private Key(Type type, AnnotationStrategy annotationStrategy) {
        this.annotationStrategy = annotationStrategy;
        this.typeLiteral = MoreTypes.canonicalizeForKey(TypeLiteral.get(type));
        this.hashCode = this.computeHashCode();
    }

    private Key(TypeLiteral<T> typeLiteral, AnnotationStrategy annotationStrategy) {
        this.annotationStrategy = annotationStrategy;
        this.typeLiteral = MoreTypes.canonicalizeForKey(typeLiteral);
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        return this.typeLiteral.hashCode() * 31 + this.annotationStrategy.hashCode();
    }

    public final TypeLiteral<T> getTypeLiteral() {
        return this.typeLiteral;
    }

    public final Class<? extends Annotation> getAnnotationType() {
        return this.annotationStrategy.getAnnotationType();
    }

    public final Annotation getAnnotation() {
        return this.annotationStrategy.getAnnotation();
    }

    boolean hasAnnotationType() {
        return this.annotationStrategy.getAnnotationType() != null;
    }

    String getAnnotationName() {
        Annotation annotation = this.annotationStrategy.getAnnotation();
        if (annotation != null) {
            return annotation.toString();
        }
        return this.annotationStrategy.getAnnotationType().toString();
    }

    Class<? super T> getRawType() {
        return this.typeLiteral.getRawType();
    }

    Key<Provider<T>> providerKey() {
        return this.ofType(this.typeLiteral.providerType());
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Key)) {
            return false;
        }
        Key key = (Key)object;
        return this.annotationStrategy.equals(key.annotationStrategy) && this.typeLiteral.equals(key.typeLiteral);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        String string = this.toString;
        if (string == null) {
            this.toString = string = "Key[type=" + this.typeLiteral + ", annotation=" + this.annotationStrategy + ']';
        }
        return string;
    }

    static <T> Key<T> get(Class<T> clazz, AnnotationStrategy annotationStrategy) {
        return new Key<T>(clazz, annotationStrategy);
    }

    public static <T> Key<T> get(Class<T> clazz) {
        return new Key<T>(clazz, (AnnotationStrategy)NullAnnotationStrategy.INSTANCE);
    }

    public static <T> Key<T> get(Class<T> clazz, Class<? extends Annotation> clazz2) {
        return new Key<T>(clazz, Key.strategyFor(clazz2));
    }

    public static <T> Key<T> get(Class<T> clazz, Annotation annotation) {
        return new Key<T>(clazz, Key.strategyFor(annotation));
    }

    public static Key<?> get(Type type) {
        return new Key(type, (AnnotationStrategy)NullAnnotationStrategy.INSTANCE);
    }

    public static Key<?> get(Type type, Class<? extends Annotation> clazz) {
        return new Key(type, Key.strategyFor(clazz));
    }

    public static Key<?> get(Type type, Annotation annotation) {
        return new Key(type, Key.strategyFor(annotation));
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral) {
        return new Key<T>(typeLiteral, (AnnotationStrategy)NullAnnotationStrategy.INSTANCE);
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral, Class<? extends Annotation> clazz) {
        return new Key<T>(typeLiteral, Key.strategyFor(clazz));
    }

    public static <T> Key<T> get(TypeLiteral<T> typeLiteral, Annotation annotation) {
        return new Key<T>(typeLiteral, Key.strategyFor(annotation));
    }

    public <U> Key<U> ofType(Class<U> clazz) {
        return new Key<T>(clazz, this.annotationStrategy);
    }

    public Key<?> ofType(Type type) {
        return new Key<T>(type, this.annotationStrategy);
    }

    public <U> Key<U> ofType(TypeLiteral<U> typeLiteral) {
        return new Key<U>(typeLiteral, this.annotationStrategy);
    }

    public Key<T> withAnnotation(Class<? extends Annotation> clazz) {
        return new Key<T>(this.typeLiteral, Key.strategyFor(clazz));
    }

    public Key<T> withAnnotation(Annotation annotation) {
        return new Key<T>(this.typeLiteral, Key.strategyFor(annotation));
    }

    public boolean hasAttributes() {
        return this.annotationStrategy.hasAttributes();
    }

    public Key<T> withoutAttributes() {
        return new Key<T>(this.typeLiteral, this.annotationStrategy.withoutAttributes());
    }

    static AnnotationStrategy strategyFor(Annotation annotation) {
        Preconditions.checkNotNull((Object)annotation, (Object)"annotation");
        Class<? extends Annotation> clazz = annotation.annotationType();
        Key.ensureRetainedAtRuntime(clazz);
        Key.ensureIsBindingAnnotation(clazz);
        if (Annotations.isMarker(clazz)) {
            return new AnnotationTypeStrategy(clazz, annotation);
        }
        return new AnnotationInstanceStrategy(Annotations.canonicalizeIfNamed(annotation));
    }

    static AnnotationStrategy strategyFor(Class<? extends Annotation> clazz) {
        if (Annotations.isAllDefaultMethods(clazz = Annotations.canonicalizeIfNamed(clazz))) {
            return Key.strategyFor(Annotations.generateAnnotation(clazz));
        }
        Preconditions.checkNotNull(clazz, (Object)"annotation type");
        Key.ensureRetainedAtRuntime(clazz);
        Key.ensureIsBindingAnnotation(clazz);
        return new AnnotationTypeStrategy(clazz, null);
    }

    private static void ensureRetainedAtRuntime(Class<? extends Annotation> clazz) {
        Preconditions.checkArgument((boolean)Annotations.isRetainedAtRuntime(clazz), (String)"%s is not retained at runtime. Please annotate it with @Retention(RUNTIME).", (Object)clazz.getName());
    }

    private static void ensureIsBindingAnnotation(Class<? extends Annotation> clazz) {
        Preconditions.checkArgument((boolean)Annotations.isBindingAnnotation(clazz), (String)"%s is not a binding annotation. Please annotate it with @BindingAnnotation.", (Object)clazz.getName());
    }

    static class AnnotationTypeStrategy
    implements AnnotationStrategy {
        final Class<? extends Annotation> annotationType;
        final Annotation annotation;

        AnnotationTypeStrategy(Class<? extends Annotation> clazz, Annotation annotation) {
            this.annotationType = (Class)Preconditions.checkNotNull(clazz, (Object)"annotation type");
            this.annotation = annotation;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        public AnnotationStrategy withoutAttributes() {
            throw new UnsupportedOperationException("Key already has no attributes.");
        }

        @Override
        public Annotation getAnnotation() {
            return this.annotation;
        }

        @Override
        public Class<? extends Annotation> getAnnotationType() {
            return this.annotationType;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AnnotationTypeStrategy)) {
                return false;
            }
            AnnotationTypeStrategy annotationTypeStrategy = (AnnotationTypeStrategy)object;
            return this.annotationType.equals(annotationTypeStrategy.annotationType);
        }

        public int hashCode() {
            return this.annotationType.hashCode();
        }

        public String toString() {
            return Annotations.annotationInstanceClassString(this.annotationType, true);
        }
    }

    static class AnnotationInstanceStrategy
    implements AnnotationStrategy {
        final Annotation annotation;

        AnnotationInstanceStrategy(Annotation annotation) {
            this.annotation = (Annotation)Preconditions.checkNotNull((Object)annotation, (Object)"annotation");
        }

        @Override
        public boolean hasAttributes() {
            return true;
        }

        @Override
        public AnnotationStrategy withoutAttributes() {
            return new AnnotationTypeStrategy(this.getAnnotationType(), this.annotation);
        }

        @Override
        public Annotation getAnnotation() {
            return this.annotation;
        }

        @Override
        public Class<? extends Annotation> getAnnotationType() {
            return this.annotation.annotationType();
        }

        public boolean equals(Object object) {
            if (!(object instanceof AnnotationInstanceStrategy)) {
                return false;
            }
            AnnotationInstanceStrategy annotationInstanceStrategy = (AnnotationInstanceStrategy)object;
            return this.annotation.equals(annotationInstanceStrategy.annotation);
        }

        public int hashCode() {
            return this.annotation.hashCode();
        }

        public String toString() {
            return this.annotation.toString();
        }
    }

    static enum NullAnnotationStrategy implements AnnotationStrategy
    {
        INSTANCE;


        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        public AnnotationStrategy withoutAttributes() {
            throw new UnsupportedOperationException("Key already has no attributes.");
        }

        @Override
        public Annotation getAnnotation() {
            return null;
        }

        @Override
        public Class<? extends Annotation> getAnnotationType() {
            return null;
        }

        public String toString() {
            return "[none]";
        }
    }

    static interface AnnotationStrategy {
        public Annotation getAnnotation();

        public Class<? extends Annotation> getAnnotationType();

        public boolean hasAttributes();

        public AnnotationStrategy withoutAttributes();
    }
}

