/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google;

import com.google.common.base.Preconditions;
import com.plotsquared.core.aopalliance.intercept.MethodInterceptor;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Key;
import com.plotsquared.google.MembersInjector;
import com.plotsquared.google.Module;
import com.plotsquared.google.PrivateBinder;
import com.plotsquared.google.Provider;
import com.plotsquared.google.Scope;
import com.plotsquared.google.Stage;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.binder.AnnotatedBindingBuilder;
import com.plotsquared.google.binder.AnnotatedConstantBindingBuilder;
import com.plotsquared.google.binder.AnnotatedElementBuilder;
import com.plotsquared.google.binder.LinkedBindingBuilder;
import com.plotsquared.google.matcher.Matcher;
import com.plotsquared.google.spi.Message;
import com.plotsquared.google.spi.ProvisionListener;
import com.plotsquared.google.spi.TypeConverter;
import com.plotsquared.google.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public abstract class PrivateModule
implements Module {
    private PrivateBinder binder;

    @Override
    public final synchronized void configure(Binder binder) {
        Preconditions.checkState((this.binder == null ? 1 : 0) != 0, (Object)"Re-entry is not allowed.");
        this.binder = (PrivateBinder)binder.skipSources(PrivateModule.class);
        try {
            this.configure();
        }
        finally {
            this.binder = null;
        }
    }

    protected abstract void configure();

    protected final <T> void expose(Key<T> key) {
        this.binder().expose(key);
    }

    protected final AnnotatedElementBuilder expose(Class<?> clazz) {
        return this.binder().expose(clazz);
    }

    protected final AnnotatedElementBuilder expose(TypeLiteral<?> typeLiteral) {
        return this.binder().expose(typeLiteral);
    }

    protected PrivateBinder binder() {
        Preconditions.checkState((this.binder != null ? 1 : 0) != 0, (Object)"The binder can only be used inside configure()");
        return this.binder;
    }

    protected final void bindScope(Class<? extends Annotation> clazz, Scope scope) {
        this.binder().bindScope(clazz, scope);
    }

    protected final <T> LinkedBindingBuilder<T> bind(Key<T> key) {
        return this.binder().bind(key);
    }

    protected final <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        return this.binder().bind(typeLiteral);
    }

    protected final <T> AnnotatedBindingBuilder<T> bind(Class<T> clazz) {
        return this.binder().bind(clazz);
    }

    protected final AnnotatedConstantBindingBuilder bindConstant() {
        return this.binder().bindConstant();
    }

    protected final void install(Module module) {
        this.binder().install(module);
    }

    protected final void addError(String string, Object ... objectArray) {
        this.binder().addError(string, objectArray);
    }

    protected final void addError(Throwable throwable) {
        this.binder().addError(throwable);
    }

    protected final void addError(Message message) {
        this.binder().addError(message);
    }

    protected final void requestInjection(Object object) {
        this.binder().requestInjection(object);
    }

    protected final void requestStaticInjection(Class<?> ... classArray) {
        this.binder().requestStaticInjection(classArray);
    }

    protected final void bindInterceptor(Matcher<? super Class<?>> matcher, Matcher<? super Method> matcher2, MethodInterceptor ... methodInterceptorArray) {
        this.binder().bindInterceptor(matcher, matcher2, methodInterceptorArray);
    }

    protected final void requireBinding(Key<?> key) {
        this.binder().getProvider(key);
    }

    protected final void requireBinding(Class<?> clazz) {
        this.binder().getProvider(clazz);
    }

    protected final <T> Provider<T> getProvider(Key<T> key) {
        return this.binder().getProvider(key);
    }

    protected final <T> Provider<T> getProvider(Class<T> clazz) {
        return this.binder().getProvider(clazz);
    }

    protected final void convertToTypes(Matcher<? super TypeLiteral<?>> matcher, TypeConverter typeConverter) {
        this.binder().convertToTypes(matcher, typeConverter);
    }

    protected final Stage currentStage() {
        return this.binder().currentStage();
    }

    protected <T> MembersInjector<T> getMembersInjector(Class<T> clazz) {
        return this.binder().getMembersInjector(clazz);
    }

    protected <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        return this.binder().getMembersInjector(typeLiteral);
    }

    protected void bindListener(Matcher<? super TypeLiteral<?>> matcher, TypeListener typeListener) {
        this.binder().bindListener(matcher, typeListener);
    }

    protected void bindListener(Matcher<? super Binding<?>> matcher, ProvisionListener ... provisionListenerArray) {
        this.binder().bindListener(matcher, provisionListenerArray);
    }
}

