/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableSet;
import com.plotsquared.google.AbstractModule;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.MembersInjector;
import com.plotsquared.google.Module;
import com.plotsquared.google.Provider;
import com.plotsquared.google.Scope;
import com.plotsquared.google.Stage;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.AbstractProcessor;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.ExposedBindingImpl;
import com.plotsquared.google.internal.InjectorBindingData;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.ProcessedBindingData;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.internal.UntargettedBindingImpl;
import com.plotsquared.google.spi.DefaultBindingTargetVisitor;

abstract class AbstractBindingProcessor
extends AbstractProcessor {
    private static final ImmutableSet<Class<?>> FORBIDDEN_TYPES = ImmutableSet.of(AbstractModule.class, Binder.class, Binding.class, Injector.class, Key.class, MembersInjector.class, (Object[])new Class[]{Module.class, Provider.class, Scope.class, Stage.class, TypeLiteral.class});
    protected final ProcessedBindingData processedBindingData;

    AbstractBindingProcessor(Errors errors, ProcessedBindingData processedBindingData) {
        super(errors);
        this.processedBindingData = processedBindingData;
    }

    protected <T> UntargettedBindingImpl<T> invalidBinding(InjectorImpl injectorImpl, Key<T> key, Object object) {
        return new UntargettedBindingImpl<T>(injectorImpl, key, object);
    }

    protected void putBinding(BindingImpl<?> bindingImpl) {
        Key<?> key;
        block6: {
            key = bindingImpl.getKey();
            Class<?> clazz = key.getTypeLiteral().getRawType();
            if (FORBIDDEN_TYPES.contains(clazz)) {
                this.errors.cannotBindToGuiceType(clazz.getSimpleName());
                return;
            }
            Binding binding = this.injector.getExistingBinding((Key)key);
            if (binding != null) {
                if (this.injector.getBindingData().getExplicitBinding(key) != null) {
                    try {
                        if (!AbstractBindingProcessor.isOkayDuplicate(binding, bindingImpl, this.injector.getBindingData())) {
                            this.errors.bindingAlreadySet(bindingImpl, binding);
                            return;
                        }
                        break block6;
                    }
                    catch (Throwable throwable) {
                        this.errors.errorCheckingDuplicateBinding(key, ((BindingImpl)binding).getSource(), throwable);
                        return;
                    }
                }
                this.errors.jitBindingAlreadySet(key);
                return;
            }
        }
        this.injector.getJitBindingData().banKeyInParent(key, this.injector.getBindingData(), bindingImpl.getSource());
        this.injector.getBindingData().putBinding(key, bindingImpl);
    }

    private static boolean isOkayDuplicate(BindingImpl<?> bindingImpl, BindingImpl<?> bindingImpl2, InjectorBindingData injectorBindingData) {
        if (bindingImpl instanceof ExposedBindingImpl) {
            ExposedBindingImpl exposedBindingImpl = (ExposedBindingImpl)bindingImpl;
            InjectorImpl injectorImpl = (InjectorImpl)exposedBindingImpl.getPrivateElements().getInjector();
            return injectorImpl == bindingImpl2.getInjector();
        }
        bindingImpl = (BindingImpl)injectorBindingData.getExplicitBindingsThisLevel().get(bindingImpl2.getKey());
        if (bindingImpl == null) {
            return false;
        }
        return bindingImpl.equals(bindingImpl2);
    }

    private <T> void validateKey(Object object, Key<T> key) {
        Annotations.checkForMisplacedScopeAnnotations(key.getTypeLiteral().getRawType(), object, this.errors);
    }

    abstract class Processor<T, V>
    extends DefaultBindingTargetVisitor<T, V> {
        final Object source;
        final Key<T> key;
        final Class<? super T> rawType;
        Scoping scoping;

        Processor(BindingImpl<T> bindingImpl) {
            this.source = bindingImpl.getSource();
            this.key = bindingImpl.getKey();
            this.rawType = this.key.getTypeLiteral().getRawType();
            this.scoping = bindingImpl.getScoping();
        }

        protected void prepareBinding() {
            AbstractBindingProcessor.this.validateKey(this.source, this.key);
            this.scoping = Scoping.makeInjectable(this.scoping, AbstractBindingProcessor.this.injector, AbstractBindingProcessor.this.errors);
        }

        protected void scheduleInitialization(BindingImpl<?> bindingImpl) {
            AbstractBindingProcessor.this.processedBindingData.addUninitializedBinding(() -> this.initializeBinding(bindingImpl));
        }

        protected void scheduleDelayedInitialization(BindingImpl<?> bindingImpl) {
            AbstractBindingProcessor.this.processedBindingData.addDelayedUninitializedBinding(() -> this.initializeBinding(bindingImpl));
        }

        private void initializeBinding(BindingImpl<?> bindingImpl) {
            try {
                bindingImpl.getInjector().initializeBinding(bindingImpl, AbstractBindingProcessor.this.errors.withSource(this.source));
            }
            catch (ErrorsException errorsException) {
                AbstractBindingProcessor.this.errors.merge(errorsException.getErrors());
            }
        }
    }
}

