/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.plotsquared.google.Binder;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.binder.AnnotatedBindingBuilder;
import com.plotsquared.google.binder.ScopedBindingBuilder;
import com.plotsquared.google.internal.AbstractBindingBuilder;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.ConstructorBindingImpl;
import com.plotsquared.google.internal.InstanceBindingImpl;
import com.plotsquared.google.internal.LinkedBindingImpl;
import com.plotsquared.google.internal.LinkedProviderBindingImpl;
import com.plotsquared.google.internal.ProviderInstanceBindingImpl;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Set;

public class BindingBuilder<T>
extends AbstractBindingBuilder<T>
implements AnnotatedBindingBuilder<T> {
    public BindingBuilder(Binder binder, List<Element> list, Object object, Key<T> key) {
        super(binder, list, object, key);
    }

    @Override
    public BindingBuilder<T> annotatedWith(Class<? extends Annotation> clazz) {
        this.annotatedWithInternal(clazz);
        return this;
    }

    @Override
    public BindingBuilder<T> annotatedWith(Annotation annotation) {
        this.annotatedWithInternal(annotation);
        return this;
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> clazz) {
        return this.to((Key)Key.get(clazz));
    }

    @Override
    public BindingBuilder<T> to(TypeLiteral<? extends T> typeLiteral) {
        return this.to((Key)Key.get(typeLiteral));
    }

    @Override
    public BindingBuilder<T> to(Key<? extends T> key) {
        Preconditions.checkNotNull(key, (Object)"linkedKey");
        this.checkNotTargetted();
        BindingImpl bindingImpl = this.getBinding();
        this.setBinding(new LinkedBindingImpl<T>(bindingImpl.getSource(), bindingImpl.getKey(), bindingImpl.getScoping(), key));
        return this;
    }

    @Override
    public void toInstance(T t) {
        Object object;
        this.checkNotTargetted();
        if (t != null) {
            try {
                object = InjectionPoint.forInstanceMethodsAndFields(t.getClass());
            }
            catch (ConfigurationException configurationException) {
                this.copyErrorsToBinder(configurationException);
                object = (Set)configurationException.getPartialValue();
            }
        } else {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
            object = ImmutableSet.of();
        }
        BindingImpl bindingImpl = this.getBinding();
        this.setBinding(new InstanceBindingImpl(bindingImpl.getSource(), bindingImpl.getKey(), Scoping.EAGER_SINGLETON, (Set<InjectionPoint>)object, t));
    }

    @Override
    public BindingBuilder<T> toProvider(Provider<? extends T> provider) {
        return this.toProvider((jakarta.inject.Provider)provider);
    }

    @Override
    public BindingBuilder<T> toProvider(jakarta.inject.Provider<? extends T> provider) {
        Set set;
        Preconditions.checkNotNull(provider, (Object)"provider");
        this.checkNotTargetted();
        try {
            set = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        }
        catch (ConfigurationException configurationException) {
            this.copyErrorsToBinder(configurationException);
            set = (Set)configurationException.getPartialValue();
        }
        BindingImpl bindingImpl = this.getBinding();
        this.setBinding(new ProviderInstanceBindingImpl<T>(bindingImpl.getSource(), bindingImpl.getKey(), bindingImpl.getScoping(), set, provider));
        return this;
    }

    @Override
    public BindingBuilder<T> toProvider(Class<? extends jakarta.inject.Provider<? extends T>> clazz) {
        return this.toProvider((Key)Key.get(clazz));
    }

    @Override
    public BindingBuilder<T> toProvider(TypeLiteral<? extends jakarta.inject.Provider<? extends T>> typeLiteral) {
        return this.toProvider((Key)Key.get(typeLiteral));
    }

    @Override
    public BindingBuilder<T> toProvider(Key<? extends jakarta.inject.Provider<? extends T>> key) {
        Preconditions.checkNotNull(key, (Object)"providerKey");
        this.checkNotTargetted();
        BindingImpl bindingImpl = this.getBinding();
        this.setBinding(new LinkedProviderBindingImpl(bindingImpl.getSource(), bindingImpl.getKey(), bindingImpl.getScoping(), key));
        return this;
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor) {
        return this.toConstructor(constructor, TypeLiteral.get(constructor.getDeclaringClass()));
    }

    @Override
    public <S extends T> ScopedBindingBuilder toConstructor(Constructor<S> constructor, TypeLiteral<? extends S> typeLiteral) {
        Set set;
        Preconditions.checkNotNull(constructor, (Object)"constructor");
        Preconditions.checkNotNull(typeLiteral, (Object)"type");
        this.checkNotTargetted();
        BindingImpl bindingImpl = this.getBinding();
        try {
            set = InjectionPoint.forInstanceMethodsAndFields(typeLiteral);
        }
        catch (ConfigurationException configurationException) {
            this.copyErrorsToBinder(configurationException);
            set = (Set)configurationException.getPartialValue();
        }
        try {
            InjectionPoint injectionPoint = InjectionPoint.forConstructor(constructor, typeLiteral);
            this.setBinding(new ConstructorBindingImpl(bindingImpl.getKey(), bindingImpl.getSource(), bindingImpl.getScoping(), injectionPoint, set));
        }
        catch (ConfigurationException configurationException) {
            this.copyErrorsToBinder(configurationException);
        }
        return this;
    }

    public String toString() {
        return "BindingBuilder<" + this.getBinding().getKey().getTypeLiteral() + ">";
    }

    private void copyErrorsToBinder(ConfigurationException configurationException) {
        for (Message message : configurationException.getErrorMessages()) {
            this.binder.addError(message);
        }
    }
}

