/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.MapMaker;
import com.plotsquared.google.internal.aop.ClassBuilding;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.BitSet;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class BytecodeGen {
    private static final Map<Class<?>, Boolean> circularProxyTypeCache = new MapMaker().weakKeys().makeMap();
    public static final String ENHANCER_BY_GUICE_MARKER = "$$EnhancerByGuice$$";
    public static final String FASTCLASS_BY_GUICE_MARKER = "$$FastClassByGuice$$";
    private static final LoadingCache<Class<?>, EnhancerBuilder> ENHANCER_BUILDERS = CacheBuilder.newBuilder().weakKeys().weakValues().build(CacheLoader.from(ClassBuilding::buildEnhancerBuilder));
    private static final ClassValue<Function<String, BiFunction<Object, Object[], Object>>> FAST_CLASSES = new ClassValue<Function<String, BiFunction<Object, Object[], Object>>>(){

        @Override
        protected Function<String, BiFunction<Object, Object[], Object>> computeValue(Class<?> clazz) {
            return ClassBuilding.buildFastClass(clazz);
        }
    };

    public static boolean isCircularProxy(Object object) {
        return object != null && circularProxyTypeCache.containsKey(object.getClass());
    }

    static <T> T newCircularProxy(Class<T> clazz, InvocationHandler invocationHandler) {
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
        circularProxyTypeCache.put(object.getClass(), Boolean.TRUE);
        return clazz.cast(object);
    }

    static EnhancerBuilder enhancerBuilder(Class<?> clazz) {
        return (EnhancerBuilder)ENHANCER_BUILDERS.getUnchecked(clazz);
    }

    static BiFunction<Object, Object[], Object> enhancedConstructor(Function<String, BiFunction<Object, Object[], Object>> function, Constructor<?> constructor) {
        Preconditions.checkArgument((boolean)ClassBuilding.canEnhance(constructor), (Object)"Constructor is not visible");
        return function.apply(ClassBuilding.signature(constructor));
    }

    static BiFunction<Object, Object[], Object> superMethod(Function<String, BiFunction<Object, Object[], Object>> function, Method method) {
        return function.apply(ClassBuilding.signature(method));
    }

    static BiFunction<Object, Object[], Object> fastConstructor(Constructor<?> constructor) {
        if (ClassBuilding.canFastInvoke(constructor)) {
            return BytecodeGen.fastClass(constructor).apply(ClassBuilding.signature(constructor));
        }
        return null;
    }

    static BiFunction<Object, Object[], Object> fastMethod(Method method) {
        if (ClassBuilding.canFastInvoke(method)) {
            return BytecodeGen.fastClass(method).apply(ClassBuilding.signature(method));
        }
        return null;
    }

    private static Function<String, BiFunction<Object, Object[], Object>> fastClass(Executable executable) {
        return FAST_CLASSES.get(executable.getDeclaringClass());
    }

    public static interface EnhancerBuilder {
        public Method[] getEnhanceableMethods();

        public Function<String, BiFunction<Object, Object[], Object>> buildEnhancer(BitSet var1);
    }
}

