/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.plotsquared.google.internal.ConstructionProxyFactory;
import com.plotsquared.google.internal.ConstructorInjector;
import com.plotsquared.google.internal.DefaultConstructionProxyFactory;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.FailableCache;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalFlags;
import com.plotsquared.google.internal.MembersInjectorImpl;
import com.plotsquared.google.internal.MethodAspect;
import com.plotsquared.google.internal.ProxyFactory;
import com.plotsquared.google.internal.SingleParameterInjector;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.InterceptorBinding;
import java.util.Set;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint injectionPoint, Errors errors) {
            return ConstructorInjectorStore.this.createConstructor(injectionPoint, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injectorImpl) {
        this.injector = injectorImpl;
    }

    boolean isLoading(InjectionPoint injectionPoint) {
        return this.cache.isLoading(injectionPoint);
    }

    public ConstructorInjector<?> get(InjectionPoint injectionPoint, Errors errors) {
        return this.cache.get(injectionPoint, errors);
    }

    boolean remove(InjectionPoint injectionPoint) {
        return this.cache.remove(injectionPoint);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) {
        int n = errors.size();
        SingleParameterInjector<?>[] singleParameterInjectorArray = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjectorImpl = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        ConstructionProxyFactory constructionProxyFactory = null;
        if (InternalFlags.isBytecodeGenEnabled()) {
            ImmutableList<InterceptorBinding> immutableList = this.injector.getBindingData().getInterceptorBindings();
            ImmutableList immutableList2 = ImmutableList.builder().addAll((Iterable)Lists.transform(immutableList, MethodAspect::fromBinding)).addAll(membersInjectorImpl.getAddedAspects()).build();
            constructionProxyFactory = new ProxyFactory(injectionPoint, (Iterable<MethodAspect>)immutableList2);
        } else {
            constructionProxyFactory = new DefaultConstructionProxyFactory(injectionPoint);
        }
        errors.throwIfNewErrors(n);
        return new ConstructorInjector((Set<InjectionPoint>)membersInjectorImpl.getInjectionPoints(), constructionProxyFactory.create(), singleParameterInjectorArray, membersInjectorImpl);
    }
}

