/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.ImplementedBy;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.MembersInjector;
import com.plotsquared.google.Module;
import com.plotsquared.google.ProvidedBy;
import com.plotsquared.google.Provider;
import com.plotsquared.google.Scope;
import com.plotsquared.google.Stage;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.ConstantFactory;
import com.plotsquared.google.internal.ConstructorBindingImpl;
import com.plotsquared.google.internal.ConstructorInjectorStore;
import com.plotsquared.google.internal.CreationListener;
import com.plotsquared.google.internal.DeferredLookups;
import com.plotsquared.google.internal.DelayedInitialize;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.FactoryProxy;
import com.plotsquared.google.internal.Initializables;
import com.plotsquared.google.internal.InjectorBindingData;
import com.plotsquared.google.internal.InjectorJitBindingData;
import com.plotsquared.google.internal.InstanceBindingImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalInjectorCreator;
import com.plotsquared.google.internal.LinkedBindingImpl;
import com.plotsquared.google.internal.LinkedProviderBindingImpl;
import com.plotsquared.google.internal.Lookups;
import com.plotsquared.google.internal.MembersInjectorImpl;
import com.plotsquared.google.internal.MembersInjectorStore;
import com.plotsquared.google.internal.MoreTypes;
import com.plotsquared.google.internal.ProvidedByInternalFactory;
import com.plotsquared.google.internal.ProvisionListenerCallbackStore;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.internal.SingleParameterInjector;
import com.plotsquared.google.internal.util.SourceProvider;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.ConvertedConstantBinding;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.HasDependencies;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.InstanceBinding;
import com.plotsquared.google.spi.ProviderBinding;
import com.plotsquared.google.spi.TypeConverterBinding;
import com.plotsquared.google.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

final class InjectorImpl
implements Injector,
Lookups {
    public static final TypeLiteral<String> STRING_TYPE = TypeLiteral.get(String.class);
    private final InjectorBindingData bindingData;
    private final InjectorJitBindingData jitBindingData;
    final InjectorImpl parent;
    final InjectorOptions options;
    Lookups lookups = new DeferredLookups(this);
    final Set<TypeLiteral<?>> userRequestedMembersInjectorTypes = Sets.newConcurrentHashSet();
    final ConstructorInjectorStore constructors = new ConstructorInjectorStore(this);
    MembersInjectorStore membersInjectorStore;
    ProvisionListenerCallbackStore provisionListenerStore;
    private final ThreadLocal<Object[]> localContext;

    InjectorImpl(InjectorImpl injectorImpl, InjectorBindingData injectorBindingData, InjectorJitBindingData injectorJitBindingData, InjectorOptions injectorOptions) {
        this.parent = injectorImpl;
        this.bindingData = injectorBindingData;
        this.jitBindingData = injectorJitBindingData;
        this.options = injectorOptions;
        this.localContext = injectorImpl != null ? injectorImpl.localContext : new ThreadLocal();
    }

    @Override
    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> typeLiteral) {
        List list = this.bindingData.getIndexedExplicitBindings().get((Object)((TypeLiteral)Preconditions.checkNotNull(typeLiteral, (Object)"type")));
        return Collections.unmodifiableList(list);
    }

    public <T> BindingImpl<T> getBinding(Key<T> key) {
        Errors errors = new Errors(Preconditions.checkNotNull(key, (Object)"key"));
        try {
            BindingImpl<T> bindingImpl = this.getBindingOrThrow(key, errors, JitLimitation.EXISTING_JIT);
            errors.throwConfigurationExceptionIfErrorsExist();
            return bindingImpl;
        }
        catch (ErrorsException errorsException) {
            ConfigurationException configurationException = new ConfigurationException(errors.merge(errorsException.getErrors()).getMessages());
            throw configurationException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BindingImpl<T> getExistingBinding(Key<T> key) {
        Object object;
        BindingImpl bindingImpl = this.bindingData.getExplicitBinding((Key)Preconditions.checkNotNull(key, (Object)"key"));
        if (bindingImpl != null) {
            return bindingImpl;
        }
        Key<T> key2 = this.jitBindingData.lock();
        synchronized (key2) {
            object = this;
            while (object != null) {
                BindingImpl<?> bindingImpl2 = ((InjectorImpl)object).jitBindingData.getJitBinding(key);
                if (bindingImpl2 != null) {
                    return bindingImpl2;
                }
                object = ((InjectorImpl)object).parent;
            }
        }
        if (InjectorImpl.isProvider(key)) {
            try {
                key2 = InjectorImpl.getProvidedKey(key, new Errors());
                if (this.getExistingBinding((Key)key2) != null) {
                    return this.getBinding((Key)key);
                }
            }
            catch (ErrorsException errorsException) {
                object = new ConfigurationException(errorsException.getErrors().getMessages());
                throw object;
            }
        }
        return null;
    }

    <T> BindingImpl<T> getBindingOrThrow(Key<T> key, Errors errors, JitLimitation jitLimitation) {
        BindingImpl<T> bindingImpl = this.bindingData.getExplicitBinding(key);
        if (bindingImpl != null) {
            return bindingImpl;
        }
        return this.getJustInTimeBinding(key, errors, jitLimitation);
    }

    @Override
    public <T> Binding<T> getBinding(Class<T> clazz) {
        return this.getBinding(Key.get((Class)Preconditions.checkNotNull(clazz, (Object)"type")));
    }

    @Override
    public Injector getParent() {
        return this.parent;
    }

    @Override
    public Injector createChildInjector(Iterable<? extends Module> iterable) {
        return new InternalInjectorCreator().parentInjector(this).addModules(iterable).build();
    }

    @Override
    public Injector createChildInjector(Module ... moduleArray) {
        return this.createChildInjector((Iterable<? extends Module>)ImmutableList.copyOf((Object[])moduleArray));
    }

    InjectorBindingData getBindingData() {
        return this.bindingData;
    }

    InjectorJitBindingData getJitBindingData() {
        return this.jitBindingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BindingImpl<T> getJustInTimeBinding(Key<T> key, Errors errors, JitLimitation jitLimitation) {
        boolean bl = InjectorImpl.isProvider(key) || InjectorImpl.isTypeLiteral(key) || InjectorImpl.isMembersInjector(key);
        Object object = this.jitBindingData.lock();
        synchronized (object) {
            InjectorImpl injectorImpl = this;
            while (injectorImpl != null) {
                BindingImpl<?> bindingImpl = injectorImpl.jitBindingData.getJitBinding(key);
                if (bindingImpl != null) {
                    if (this.options.jitDisabled && jitLimitation == JitLimitation.NO_JIT && !bl && !(bindingImpl instanceof ConvertedConstantBindingImpl)) {
                        throw errors.jitDisabled(key).toException();
                    }
                    return bindingImpl;
                }
                injectorImpl = injectorImpl.parent;
            }
            if (this.jitBindingData.isFailedJitBinding(key) && errors.hasErrors()) {
                throw errors.toException();
            }
            return this.createJustInTimeBindingRecursive(key, errors, this.options.jitDisabled, jitLimitation);
        }
    }

    private static boolean isProvider(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(Provider.class);
    }

    private static boolean isTypeLiteral(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(TypeLiteral.class);
    }

    private static <T> Key<T> getProvidedKey(Key<Provider<T>> key, Errors errors) {
        Type type = key.getTypeLiteral().getType();
        if (!(type instanceof ParameterizedType)) {
            throw errors.cannotInjectRawProvider().toException();
        }
        Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
        Key<?> key2 = key.ofType(type2);
        return key2;
    }

    private static boolean isMembersInjector(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(MembersInjector.class) && key.getAnnotationType() == null;
    }

    private <T> BindingImpl<MembersInjector<T>> createMembersInjectorBinding(Key<MembersInjector<T>> key, Errors errors) {
        Type type = key.getTypeLiteral().getType();
        if (!(type instanceof ParameterizedType)) {
            throw errors.cannotInjectRawMembersInjector().toException();
        }
        TypeLiteral<?> typeLiteral = TypeLiteral.get(((ParameterizedType)type).getActualTypeArguments()[0]);
        MembersInjectorImpl<?> membersInjectorImpl = this.membersInjectorStore.get(typeLiteral, errors);
        ConstantFactory constantFactory = new ConstantFactory(Initializables.of(membersInjectorImpl));
        return new InstanceBindingImpl<MembersInjector<T>>(this, key, SourceProvider.UNKNOWN_SOURCE, constantFactory, (Set<InjectionPoint>)ImmutableSet.of(), membersInjectorImpl);
    }

    private <T> BindingImpl<Provider<T>> createSyntheticProviderBinding(Key<Provider<T>> key, Errors errors) {
        Key<T> key2 = InjectorImpl.getProvidedKey(key, errors);
        BindingImpl<T> bindingImpl = this.getBindingOrThrow(key2, errors, JitLimitation.NO_JIT);
        return new SyntheticProviderBindingImpl<T>(this, key, bindingImpl);
    }

    private <T> BindingImpl<T> convertConstantStringBinding(Key<T> key, Errors errors) {
        Key<String> key2 = key.ofType(STRING_TYPE);
        BindingImpl<String> bindingImpl = this.bindingData.getExplicitBinding(key2);
        if (bindingImpl == null || !bindingImpl.isConstant()) {
            return null;
        }
        String string = (String)((InstanceBinding)((Object)bindingImpl)).getInstance();
        Object object = bindingImpl.getSource();
        TypeLiteral<T> typeLiteral = key.getTypeLiteral();
        TypeConverterBinding typeConverterBinding = this.bindingData.getConverter(string, typeLiteral, errors, object);
        if (typeConverterBinding == null) {
            return null;
        }
        try {
            Object object2 = typeConverterBinding.getTypeConverter().convert(string, typeLiteral);
            if (object2 == null) {
                throw errors.converterReturnedNull(string, object, typeLiteral, typeConverterBinding).toException();
            }
            if (!typeLiteral.getRawType().isInstance(object2)) {
                throw errors.conversionTypeError(string, object, typeLiteral, typeConverterBinding, object2).toException();
            }
            return new ConvertedConstantBindingImpl<Object>(this, key, object2, bindingImpl, typeConverterBinding);
        }
        catch (ErrorsException errorsException) {
            throw errorsException;
        }
        catch (RuntimeException runtimeException) {
            throw errors.conversionError(string, object, typeLiteral, typeConverterBinding, runtimeException).toException();
        }
    }

    <T> void initializeBinding(BindingImpl<T> bindingImpl, Errors errors) {
        if (bindingImpl instanceof DelayedInitialize) {
            ((DelayedInitialize)((Object)bindingImpl)).initialize(this, errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void initializeJitBinding(BindingImpl<T> bindingImpl, Errors errors) {
        if (bindingImpl instanceof DelayedInitialize) {
            Key<T> key = bindingImpl.getKey();
            this.jitBindingData.putJitBinding(key, bindingImpl);
            boolean bl = false;
            DelayedInitialize delayedInitialize = (DelayedInitialize)((Object)bindingImpl);
            try {
                delayedInitialize.initialize(this, errors);
                bl = true;
            }
            finally {
                if (!bl) {
                    this.removeFailedJitBinding(bindingImpl, null);
                    this.cleanup(bindingImpl, new HashSet());
                }
            }
        }
    }

    private boolean cleanup(BindingImpl<?> bindingImpl, Set<Key<?>> set) {
        boolean bl = false;
        Set<Dependency<?>> set2 = this.getInternalDependencies(bindingImpl);
        for (Dependency<?> dependency : set2) {
            Key<?> key = dependency.getKey();
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            if (!set.add(key)) continue;
            BindingImpl<?> bindingImpl2 = this.jitBindingData.getJitBinding(key);
            if (bindingImpl2 != null) {
                boolean bl2 = this.cleanup(bindingImpl2, set);
                if (bindingImpl2 instanceof ConstructorBindingImpl) {
                    ConstructorBindingImpl constructorBindingImpl = (ConstructorBindingImpl)bindingImpl2;
                    injectionPoint = constructorBindingImpl.getInternalConstructor();
                    if (!constructorBindingImpl.isInitialized()) {
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                this.removeFailedJitBinding(bindingImpl2, injectionPoint);
                bl = true;
                continue;
            }
            if (this.bindingData.getExplicitBinding(key) != null) continue;
            bl = true;
        }
        return bl;
    }

    private void removeFailedJitBinding(Binding<?> binding, InjectionPoint injectionPoint) {
        this.jitBindingData.addFailedJitBinding(binding.getKey());
        if (injectionPoint == null || !this.constructors.isLoading(injectionPoint)) {
            this.jitBindingData.removeJitBinding(binding.getKey());
        }
        if (injectionPoint != null && !this.constructors.isLoading(injectionPoint)) {
            this.constructors.remove(injectionPoint);
        }
        this.membersInjectorStore.remove(binding.getKey().getTypeLiteral());
        this.provisionListenerStore.remove(binding);
    }

    private Set<Dependency<?>> getInternalDependencies(BindingImpl<?> bindingImpl) {
        if (bindingImpl instanceof ConstructorBindingImpl) {
            return ((ConstructorBindingImpl)bindingImpl).getInternalDependencies();
        }
        if (bindingImpl instanceof HasDependencies) {
            return ((HasDependencies)((Object)bindingImpl)).getDependencies();
        }
        return ImmutableSet.of();
    }

    <T> BindingImpl<T> createUninitializedBinding(Key<T> key, Scoping scoping, Object object, Errors errors, boolean bl, Consumer<CreationListener> consumer) {
        Class<T> clazz = key.getTypeLiteral().getRawType();
        ImplementedBy implementedBy = clazz.getAnnotation(ImplementedBy.class);
        if (clazz.isArray() || clazz.isEnum() && implementedBy != null) {
            throw errors.missingImplementationWithHint(key, this).toException();
        }
        if (clazz == TypeLiteral.class) {
            BindingImpl<TypeLiteral<T>> bindingImpl = this.createTypeLiteralBinding(key, errors);
            return bindingImpl;
        }
        if (implementedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(clazz, object, errors);
            return this.createImplementedByBinding(key, scoping, implementedBy, errors, consumer);
        }
        ProvidedBy providedBy = clazz.getAnnotation(ProvidedBy.class);
        if (providedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(clazz, object, errors);
            return this.createProvidedByBinding(key, scoping, providedBy, errors);
        }
        return ConstructorBindingImpl.create(this, key, null, object, scoping, errors, bl && this.options.jitDisabled, this.options.atInjectRequired);
    }

    private <T> BindingImpl<TypeLiteral<T>> createTypeLiteralBinding(Key<TypeLiteral<T>> key, Errors errors) {
        Type type = key.getTypeLiteral().getType();
        if (!(type instanceof ParameterizedType)) {
            throw errors.cannotInjectRawTypeLiteral().toException();
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type type2 = parameterizedType.getActualTypeArguments()[0];
        if (!(type2 instanceof Class || type2 instanceof GenericArrayType || type2 instanceof ParameterizedType)) {
            throw errors.cannotInjectTypeLiteralOf(type2).toException();
        }
        TypeLiteral<?> typeLiteral = TypeLiteral.get(type2);
        ConstantFactory constantFactory = new ConstantFactory(Initializables.of(typeLiteral));
        return new InstanceBindingImpl<TypeLiteral<T>>(this, key, SourceProvider.UNKNOWN_SOURCE, constantFactory, (Set<InjectionPoint>)ImmutableSet.of(), typeLiteral);
    }

    <T> BindingImpl<T> createProvidedByBinding(Key<T> key, Scoping scoping, ProvidedBy providedBy, Errors errors) {
        Class<? extends Annotation> clazz;
        Class<T> clazz2 = key.getTypeLiteral().getRawType();
        Class<? extends jakarta.inject.Provider<?>> clazz3 = providedBy.value();
        if (clazz3 == clazz2) {
            throw errors.recursiveProviderType().toException();
        }
        if (!scoping.isExplicitlyScoped()) {
            int n = errors.size();
            clazz = Annotations.findScopeAnnotation(errors, clazz2);
            if (clazz != null) {
                scoping = Scoping.makeInjectable(Scoping.forAnnotation(clazz), this, errors.withSource(clazz2));
            }
            errors.throwIfNewErrors(n);
        }
        Key<? extends jakarta.inject.Provider<?>> key2 = Key.get(clazz3);
        clazz = new ProvidedByInternalFactory(clazz2, clazz3, key2);
        Class<T> clazz4 = clazz2;
        LinkedProviderBindingImpl<T> linkedProviderBindingImpl = LinkedProviderBindingImpl.createWithInitializer(this, key, clazz4, Scoping.scope(key, this, clazz, clazz4, scoping), scoping, key2, (DelayedInitialize)((Object)clazz));
        ((ProvidedByInternalFactory)((Object)clazz)).setProvisionListenerCallback(this.provisionListenerStore.get(linkedProviderBindingImpl));
        return linkedProviderBindingImpl;
    }

    private <T> BindingImpl<T> createImplementedByBinding(Key<T> key, Scoping scoping, ImplementedBy implementedBy, Errors errors, Consumer<CreationListener> consumer) {
        Class<T> clazz = key.getTypeLiteral().getRawType();
        Class<?> clazz2 = implementedBy.value();
        if (clazz2 == clazz) {
            throw errors.recursiveImplementationType().toException();
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw errors.notASubtype(clazz2, clazz).toException();
        }
        Class<?> clazz3 = clazz2;
        Key<?> key2 = Key.get(clazz3);
        Class<T> clazz4 = clazz;
        FactoryProxy<T> factoryProxy = new FactoryProxy<T>(this, key, key2, clazz4);
        consumer.accept(factoryProxy);
        return new LinkedBindingImpl<T>(this, key, clazz4, Scoping.scope(key, this, factoryProxy, clazz4, scoping), scoping, key2);
    }

    private <T> BindingImpl<T> createJustInTimeBindingRecursive(Key<T> key, Errors errors, boolean bl, JitLimitation jitLimitation) {
        if (this.parent != null) {
            if (jitLimitation == JitLimitation.NEW_OR_EXISTING_JIT && bl && !this.parent.options.jitDisabled) {
                throw errors.jitDisabledInParent(key).toException();
            }
            try {
                return this.parent.createJustInTimeBindingRecursive(key, new Errors(), bl, this.parent.options.jitDisabled ? JitLimitation.NO_JIT : jitLimitation);
            }
            catch (ErrorsException errorsException) {
                // empty catch block
            }
        }
        Set<Object> set = this.jitBindingData.getSourcesForBannedKey(key);
        if (this.jitBindingData.isBannedKey(key)) {
            throw errors.childBindingAlreadySet(key, set).toException();
        }
        key = MoreTypes.canonicalizeKey(key);
        BindingImpl<T> bindingImpl = this.createJustInTimeBinding(key, errors, bl, jitLimitation);
        this.jitBindingData.banKeyInParent(key, this.bindingData, bindingImpl.getSource());
        this.jitBindingData.putJitBinding(key, bindingImpl);
        return bindingImpl;
    }

    private <T> BindingImpl<T> createJustInTimeBinding(Key<T> key, Errors errors, boolean bl, JitLimitation jitLimitation) {
        int n = errors.size();
        Set<Object> set = this.jitBindingData.getSourcesForBannedKey(key);
        if (this.jitBindingData.isBannedKey(key)) {
            throw errors.childBindingAlreadySet(key, set).toException();
        }
        if (InjectorImpl.isProvider(key)) {
            BindingImpl<Provider<T>> bindingImpl = this.createSyntheticProviderBinding(key, errors);
            return bindingImpl;
        }
        if (InjectorImpl.isMembersInjector(key)) {
            BindingImpl<MembersInjector<T>> bindingImpl = this.createMembersInjectorBinding(key, errors);
            return bindingImpl;
        }
        BindingImpl<Provider<T>> bindingImpl = this.convertConstantStringBinding(key, errors);
        if (bindingImpl != null) {
            return bindingImpl;
        }
        if (!InjectorImpl.isTypeLiteral(key) && bl && jitLimitation != JitLimitation.NEW_OR_EXISTING_JIT) {
            throw errors.jitDisabled(key).toException();
        }
        if (key.getAnnotationType() != null) {
            if (key.hasAttributes() && !this.options.exactBindingAnnotationsRequired) {
                try {
                    Errors errors2 = new Errors();
                    return this.getBindingOrThrow(key.withoutAttributes(), errors2, JitLimitation.NO_JIT);
                }
                catch (ErrorsException errorsException) {
                    // empty catch block
                }
            }
            throw errors.missingImplementationWithHint(key, this).toException();
        }
        Class<Provider<T>> clazz = key.getTypeLiteral().getRawType();
        BindingImpl<Provider<T>> bindingImpl2 = this.createUninitializedBinding(key, Scoping.UNSCOPED, clazz, errors, true, creationListener -> creationListener.notify(errors));
        errors.throwIfNewErrors(n);
        this.initializeJitBinding(bindingImpl2, errors);
        return bindingImpl2;
    }

    <T> InternalFactory<? extends T> getInternalFactory(Key<T> key, Errors errors, JitLimitation jitLimitation) {
        return this.getBindingOrThrow(key, errors, jitLimitation).getInternalFactory();
    }

    @Override
    public Map<Key<?>, Binding<?>> getBindings() {
        return this.bindingData.getExplicitBindingsThisLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Key<?>, Binding<?>> getAllBindings() {
        Object object = this.jitBindingData.lock();
        synchronized (object) {
            return new ImmutableMap.Builder().putAll(this.bindingData.getExplicitBindingsThisLevel()).putAll(this.jitBindingData.getJitBindings()).buildOrThrow();
        }
    }

    @Override
    public Map<Class<? extends Annotation>, Scope> getScopeBindings() {
        return ImmutableMap.copyOf(this.bindingData.getScopes());
    }

    @Override
    public Set<TypeConverterBinding> getTypeConverterBindings() {
        return ImmutableSet.copyOf(this.bindingData.getConvertersThisLevel());
    }

    @Override
    public List<Element> getElements() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.getAllBindings().values());
        builder.addAll(this.bindingData.getProviderLookupsThisLevel());
        builder.addAll(this.bindingData.getConvertersThisLevel());
        builder.addAll(this.bindingData.getScopeBindingsThisLevel());
        builder.addAll(this.bindingData.getTypeListenerBindingsThisLevel());
        builder.addAll(this.bindingData.getProvisionListenerBindingsThisLevel());
        builder.addAll(this.bindingData.getScannerBindingsThisLevel());
        builder.addAll(this.bindingData.getStaticInjectionRequestsThisLevel());
        builder.addAll(this.bindingData.getMembersInjectorLookupsThisLevel());
        builder.addAll(this.bindingData.getInjectionRequestsThisLevel());
        builder.addAll(this.bindingData.getInterceptorBindingsThisLevel());
        return builder.build();
    }

    @Override
    public Map<TypeLiteral<?>, List<InjectionPoint>> getAllMembersInjectorInjectionPoints() {
        ImmutableMap immutableMap = ImmutableListMultimap.copyOf((Multimap)Multimaps.filterKeys(this.membersInjectorStore.getAllInjectionPoints(), this.userRequestedMembersInjectorTypes::contains)).asMap();
        return immutableMap;
    }

    SingleParameterInjector<?>[] getParametersInjectors(List<Dependency<?>> list, Errors errors) {
        if (list.isEmpty()) {
            return null;
        }
        int n = errors.size();
        SingleParameterInjector[] singleParameterInjectorArray = new SingleParameterInjector[list.size()];
        int n2 = 0;
        for (Dependency<?> dependency : list) {
            try {
                singleParameterInjectorArray[n2++] = this.createParameterInjector(dependency, errors.withSource(dependency));
            }
            catch (ErrorsException errorsException) {}
        }
        errors.throwIfNewErrors(n);
        return singleParameterInjectorArray;
    }

    <T> SingleParameterInjector<T> createParameterInjector(Dependency<T> dependency, Errors errors) {
        BindingImpl<T> bindingImpl = this.getBindingOrThrow(dependency.getKey(), errors, JitLimitation.NO_JIT);
        return new SingleParameterInjector<T>(dependency, bindingImpl);
    }

    @Override
    public void injectMembers(Object object) {
        MembersInjector<?> membersInjector = this.getMembersInjector(object.getClass());
        membersInjector.injectMembers(object);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        Preconditions.checkNotNull(typeLiteral, (Object)"typeLiteral");
        this.userRequestedMembersInjectorTypes.add(typeLiteral);
        Errors errors = new Errors(typeLiteral);
        try {
            return this.membersInjectorStore.get(typeLiteral, errors);
        }
        catch (ErrorsException errorsException) {
            ConfigurationException configurationException = new ConfigurationException(errors.merge(errorsException.getErrors()).getMessages());
            throw configurationException;
        }
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> clazz) {
        return this.getMembersInjector(TypeLiteral.get(clazz));
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> clazz) {
        return this.getProvider(Key.get((Class)Preconditions.checkNotNull(clazz, (Object)"type")));
    }

    <T> Provider<T> getProviderOrThrow(final Dependency<T> dependency, Errors errors) {
        Key<T> key = dependency.getKey();
        BindingImpl<T> bindingImpl = this.getBindingOrThrow(key, errors, JitLimitation.NO_JIT);
        final InternalFactory<T> internalFactory = bindingImpl.getInternalFactory();
        return new Provider<T>(){

            @Override
            public T get() {
                try (InternalContext internalContext = InjectorImpl.this.enterContext();){
                    Object t;
                    Object t2 = t = internalFactory.get(internalContext, dependency, false);
                    return t2;
                }
            }

            public String toString() {
                return internalFactory.toString();
            }
        };
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        Errors errors = new Errors(key);
        try {
            Provider<T> provider = this.getProviderOrThrow(Dependency.get(key), errors);
            errors.throwIfNewErrors(0);
            return provider;
        }
        catch (ErrorsException errorsException) {
            ConfigurationException configurationException = new ConfigurationException(errors.merge(errorsException.getErrors()).getMessages());
            throw configurationException;
        }
    }

    @Override
    public <T> T getInstance(Key<T> key) {
        return this.getProvider(key).get();
    }

    @Override
    public <T> T getInstance(Class<T> clazz) {
        return this.getProvider(clazz).get();
    }

    InternalContext getLocalContext() {
        return (InternalContext)this.localContext.get()[0];
    }

    InternalContext enterContext() {
        InternalContext internalContext;
        Object[] objectArray = this.localContext.get();
        if (objectArray == null) {
            objectArray = new Object[1];
            this.localContext.set(objectArray);
        }
        if ((internalContext = (InternalContext)objectArray[0]) == null) {
            internalContext = new InternalContext(this.options, objectArray);
            objectArray[0] = internalContext;
        } else {
            internalContext.enter();
        }
        return internalContext;
    }

    public String toString() {
        return MoreObjects.toStringHelper(Injector.class).add("bindings", this.bindingData.getExplicitBindingsThisLevel().values()).toString();
    }

    static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2) throws IllegalAccessException, InvocationTargetException;
    }

    private static class ConvertedConstantBindingImpl<T>
    extends BindingImpl<T>
    implements ConvertedConstantBinding<T> {
        final T value;
        final Provider<T> provider;
        final Binding<String> originalBinding;
        final TypeConverterBinding typeConverterBinding;

        ConvertedConstantBindingImpl(InjectorImpl injectorImpl, Key<T> key, T t, Binding<String> binding, TypeConverterBinding typeConverterBinding) {
            super(injectorImpl, key, binding.getSource(), new ConstantFactory<T>(Initializables.of(t)), Scoping.UNSCOPED);
            this.value = t;
            this.provider = Providers.of(t);
            this.originalBinding = binding;
            this.typeConverterBinding = typeConverterBinding;
        }

        @Override
        public Provider<T> getProvider() {
            return this.provider;
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> bindingTargetVisitor) {
            return bindingTargetVisitor.visit(this);
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public TypeConverterBinding getTypeConverterBinding() {
            return this.typeConverterBinding;
        }

        @Override
        public Key<String> getSourceKey() {
            return this.originalBinding.getKey();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return ImmutableSet.of(Dependency.get(this.getSourceKey()));
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(ConvertedConstantBinding.class).add("key", this.getKey()).add("sourceKey", this.getSourceKey()).add("value", this.value).toString();
        }

        public boolean equals(Object object) {
            if (object instanceof ConvertedConstantBindingImpl) {
                ConvertedConstantBindingImpl convertedConstantBindingImpl = (ConvertedConstantBindingImpl)object;
                return this.getKey().equals(convertedConstantBindingImpl.getKey()) && this.getScoping().equals(convertedConstantBindingImpl.getScoping()) && Objects.equal(this.value, convertedConstantBindingImpl.value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getKey(), this.getScoping(), this.value});
        }
    }

    private static class SyntheticProviderBindingImpl<T>
    extends BindingImpl<Provider<T>>
    implements ProviderBinding<Provider<T>>,
    HasDependencies {
        final BindingImpl<T> providedBinding;

        SyntheticProviderBindingImpl(InjectorImpl injectorImpl, Key<Provider<T>> key, Binding<T> binding) {
            super(injectorImpl, key, binding.getSource(), SyntheticProviderBindingImpl.createInternalFactory(binding), Scoping.UNSCOPED);
            this.providedBinding = (BindingImpl)binding;
        }

        static <T> InternalFactory<Provider<T>> createInternalFactory(Binding<T> binding) {
            final Provider<T> provider = binding.getProvider();
            return new InternalFactory<Provider<T>>(){

                @Override
                public Provider<T> get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
                    return provider;
                }
            };
        }

        @Override
        public Key<? extends T> getProvidedKey() {
            return this.providedBinding.getKey();
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super Provider<T>, V> bindingTargetVisitor) {
            return bindingTargetVisitor.visit(this);
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(ProviderBinding.class).add("key", this.getKey()).add("providedKey", this.getProvidedKey()).toString();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return ImmutableSet.of(Dependency.get(this.getProvidedKey()));
        }

        public boolean equals(Object object) {
            if (object instanceof SyntheticProviderBindingImpl) {
                SyntheticProviderBindingImpl syntheticProviderBindingImpl = (SyntheticProviderBindingImpl)object;
                return this.getKey().equals(syntheticProviderBindingImpl.getKey()) && this.getScoping().equals(syntheticProviderBindingImpl.getScoping()) && Objects.equal(this.providedBinding, syntheticProviderBindingImpl.providedBinding);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getKey(), this.getScoping(), this.providedBinding});
        }
    }

    static enum JitLimitation {
        NO_JIT,
        EXISTING_JIT,
        NEW_OR_EXISTING_JIT;

    }

    static class InjectorOptions {
        final Stage stage;
        final boolean jitDisabled;
        final boolean disableCircularProxies;
        final boolean atInjectRequired;
        final boolean exactBindingAnnotationsRequired;

        InjectorOptions(Stage stage, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.stage = stage;
            this.jitDisabled = bl;
            this.disableCircularProxies = bl2;
            this.atInjectRequired = bl3;
            this.exactBindingAnnotationsRequired = bl4;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("stage", (Object)this.stage).add("jitDisabled", this.jitDisabled).add("disableCircularProxies", this.disableCircularProxies).add("atInjectRequired", this.atInjectRequired).add("exactBindingAnnotationsRequired", this.exactBindingAnnotationsRequired).toString();
        }
    }
}

