/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.plotsquared.google.Stage;
import com.plotsquared.google.internal.AbstractProcessor;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.spi.DisableCircularProxiesOption;
import com.plotsquared.google.spi.RequireAtInjectOnConstructorsOption;
import com.plotsquared.google.spi.RequireExactBindingAnnotationsOption;
import com.plotsquared.google.spi.RequireExplicitBindingsOption;

class InjectorOptionsProcessor
extends AbstractProcessor {
    private boolean disableCircularProxies = false;
    private boolean jitDisabled = false;
    private boolean atInjectRequired = false;
    private boolean exactBindingAnnotationsRequired = false;

    InjectorOptionsProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(DisableCircularProxiesOption disableCircularProxiesOption) {
        this.disableCircularProxies = true;
        return true;
    }

    @Override
    public Boolean visit(RequireExplicitBindingsOption requireExplicitBindingsOption) {
        this.jitDisabled = true;
        return true;
    }

    @Override
    public Boolean visit(RequireAtInjectOnConstructorsOption requireAtInjectOnConstructorsOption) {
        this.atInjectRequired = true;
        return true;
    }

    @Override
    public Boolean visit(RequireExactBindingAnnotationsOption requireExactBindingAnnotationsOption) {
        this.exactBindingAnnotationsRequired = true;
        return true;
    }

    InjectorImpl.InjectorOptions getOptions(Stage stage, InjectorImpl.InjectorOptions injectorOptions) {
        Preconditions.checkNotNull((Object)((Object)stage), (Object)"stage must be set");
        if (injectorOptions == null) {
            return new InjectorImpl.InjectorOptions(stage, this.jitDisabled, this.disableCircularProxies, this.atInjectRequired, this.exactBindingAnnotationsRequired);
        }
        Preconditions.checkState((stage == injectorOptions.stage ? 1 : 0) != 0, (Object)"child & parent stage don't match");
        return new InjectorImpl.InjectorOptions(stage, this.jitDisabled || injectorOptions.jitDisabled, this.disableCircularProxies || injectorOptions.disableCircularProxies, this.atInjectRequired || injectorOptions.atInjectRequired, this.exactBindingAnnotationsRequired || injectorOptions.exactBindingAnnotationsRequired);
    }
}

