/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Stopwatch;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.MembersInjector;
import com.plotsquared.google.Module;
import com.plotsquared.google.Provider;
import com.plotsquared.google.Scope;
import com.plotsquared.google.Stage;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.DeferredLookups;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.Initializer;
import com.plotsquared.google.internal.InjectionRequestProcessor;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InjectorShell;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.LinkedBindingImpl;
import com.plotsquared.google.internal.LookupProcessor;
import com.plotsquared.google.internal.ProcessedBindingData;
import com.plotsquared.google.internal.util.ContinuousStopwatch;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.TypeConverterBinding;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class InternalInjectorCreator {
    private final ContinuousStopwatch stopwatch = new ContinuousStopwatch(Stopwatch.createUnstarted());
    private final Errors errors = new Errors();
    private final Initializer initializer = new Initializer();
    private final ProcessedBindingData processedBindingData;
    private final InjectionRequestProcessor injectionRequestProcessor;
    private final InjectorShell.Builder shellBuilder = new InjectorShell.Builder();
    private List<InjectorShell> shells;

    public InternalInjectorCreator() {
        this.injectionRequestProcessor = new InjectionRequestProcessor(this.errors, this.initializer);
        this.processedBindingData = new ProcessedBindingData();
    }

    public InternalInjectorCreator stage(Stage stage) {
        this.shellBuilder.stage(stage);
        return this;
    }

    public InternalInjectorCreator parentInjector(InjectorImpl injectorImpl) {
        this.shellBuilder.parent(injectorImpl);
        return this;
    }

    public InternalInjectorCreator addModules(Iterable<? extends Module> iterable) {
        this.shellBuilder.addModules(iterable);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector build() {
        if (this.shellBuilder == null) {
            throw new AssertionError((Object)"Already built, builders are not reusable.");
        }
        Object object = this.shellBuilder.lock();
        synchronized (object) {
            this.shells = this.shellBuilder.build(this.initializer, this.processedBindingData, this.stopwatch, this.errors);
            this.stopwatch.resetAndLog("Injector construction");
            this.initializeStatically();
        }
        this.injectDynamically();
        if (this.shellBuilder.getStage() == Stage.TOOL) {
            return new ToolStageInjector(this.primaryInjector());
        }
        return this.primaryInjector();
    }

    private void initializeStatically() {
        this.processedBindingData.initializeBindings();
        this.stopwatch.resetAndLog("Binding initialization");
        for (InjectorShell injectorShell : this.shells) {
            injectorShell.getInjector().getBindingData().indexBindingsByType();
        }
        this.stopwatch.resetAndLog("Binding indexing");
        this.injectionRequestProcessor.process(this.shells);
        this.stopwatch.resetAndLog("Collecting injection requests");
        this.processedBindingData.runCreationListeners(this.errors);
        this.stopwatch.resetAndLog("Binding validation");
        this.injectionRequestProcessor.validate();
        this.stopwatch.resetAndLog("Static validation");
        this.initializer.validateOustandingInjections(this.errors);
        this.stopwatch.resetAndLog("Instance member validation");
        new LookupProcessor(this.errors).process(this.shells);
        for (InjectorShell injectorShell : this.shells) {
            ((DeferredLookups)injectorShell.getInjector().lookups).initialize(this.errors);
        }
        this.stopwatch.resetAndLog("Provider verification");
        this.processedBindingData.initializeDelayedBindings();
        this.stopwatch.resetAndLog("Delayed Binding initialization");
        for (InjectorShell injectorShell : this.shells) {
            if (!injectorShell.getElements().isEmpty()) {
                throw new AssertionError((Object)("Failed to execute " + injectorShell.getElements()));
            }
        }
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    private Injector primaryInjector() {
        return this.shells.get(0).getInjector();
    }

    private void injectDynamically() {
        this.injectionRequestProcessor.injectMembers();
        this.stopwatch.resetAndLog("Static member injection");
        this.initializer.injectAll(this.errors);
        this.stopwatch.resetAndLog("Instance injection");
        this.errors.throwCreationExceptionIfErrorsExist();
        if (this.shellBuilder.getStage() != Stage.TOOL) {
            for (InjectorShell injectorShell : this.shells) {
                this.loadEagerSingletons(injectorShell.getInjector(), this.shellBuilder.getStage(), this.errors);
            }
            this.stopwatch.resetAndLog("Preloading singletons");
        }
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadEagerSingletons(InjectorImpl injectorImpl, Stage stage, Errors errors) {
        ArrayList arrayList = new ArrayList();
        Collection<Binding<?>> collection = injectorImpl.getBindingData().getExplicitBindingsThisLevel().values();
        arrayList.addAll(collection);
        Object object = injectorImpl.getJitBindingData().lock();
        synchronized (object) {
            arrayList.addAll(injectorImpl.getJitBindingData().getJitBindings().values());
        }
        object = injectorImpl.enterContext();
        try {
            for (BindingImpl bindingImpl : arrayList) {
                if (!this.isEagerSingleton(injectorImpl, bindingImpl, stage)) continue;
                Dependency dependency = Dependency.get(bindingImpl.getKey());
                try {
                    bindingImpl.getInternalFactory().get((InternalContext)object, dependency, false);
                }
                catch (InternalProvisionException internalProvisionException) {
                    errors.withSource(dependency).merge(internalProvisionException);
                }
            }
        }
        finally {
            ((InternalContext)object).close();
        }
    }

    private boolean isEagerSingleton(InjectorImpl injectorImpl, BindingImpl<?> bindingImpl, Stage stage) {
        if (bindingImpl.getScoping().isEagerSingleton(stage)) {
            return true;
        }
        if (bindingImpl instanceof LinkedBindingImpl) {
            Key key = ((LinkedBindingImpl)bindingImpl).getLinkedKey();
            return bindingImpl.getScoping().isNoScope() && this.isEagerSingleton(injectorImpl, (BindingImpl<?>)injectorImpl.getBinding(key), stage);
        }
        return false;
    }

    static class ToolStageInjector
    implements Injector {
        private final Injector delegateInjector;

        ToolStageInjector(Injector injector) {
            this.delegateInjector = injector;
        }

        @Override
        public void injectMembers(Object object) {
            throw new UnsupportedOperationException("Injector.injectMembers(Object) is not supported in Stage.TOOL");
        }

        @Override
        public Map<Key<?>, Binding<?>> getBindings() {
            return this.delegateInjector.getBindings();
        }

        @Override
        public Map<Key<?>, Binding<?>> getAllBindings() {
            return this.delegateInjector.getAllBindings();
        }

        @Override
        public <T> Binding<T> getBinding(Key<T> key) {
            return this.delegateInjector.getBinding(key);
        }

        @Override
        public <T> Binding<T> getBinding(Class<T> clazz) {
            return this.delegateInjector.getBinding(clazz);
        }

        @Override
        public <T> Binding<T> getExistingBinding(Key<T> key) {
            return this.delegateInjector.getExistingBinding(key);
        }

        @Override
        public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> typeLiteral) {
            return this.delegateInjector.findBindingsByType(typeLiteral);
        }

        @Override
        public Injector getParent() {
            return this.delegateInjector.getParent();
        }

        @Override
        public Injector createChildInjector(Iterable<? extends Module> iterable) {
            return this.delegateInjector.createChildInjector(iterable);
        }

        @Override
        public Injector createChildInjector(Module ... moduleArray) {
            return this.delegateInjector.createChildInjector(moduleArray);
        }

        @Override
        public Map<Class<? extends Annotation>, Scope> getScopeBindings() {
            return this.delegateInjector.getScopeBindings();
        }

        @Override
        public Set<TypeConverterBinding> getTypeConverterBindings() {
            return this.delegateInjector.getTypeConverterBindings();
        }

        @Override
        public List<Element> getElements() {
            return this.delegateInjector.getElements();
        }

        @Override
        public Map<TypeLiteral<?>, List<InjectionPoint>> getAllMembersInjectorInjectionPoints() {
            return this.delegateInjector.getAllMembersInjectorInjectionPoints();
        }

        @Override
        public <T> Provider<T> getProvider(Key<T> key) {
            throw new UnsupportedOperationException("Injector.getProvider(Key<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> Provider<T> getProvider(Class<T> clazz) {
            throw new UnsupportedOperationException("Injector.getProvider(Class<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
            throw new UnsupportedOperationException("Injector.getMembersInjector(TypeLiteral<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(Class<T> clazz) {
            throw new UnsupportedOperationException("Injector.getMembersInjector(Class<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> T getInstance(Key<T> key) {
            throw new UnsupportedOperationException("Injector.getInstance(Key<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> T getInstance(Class<T> clazz) {
            throw new UnsupportedOperationException("Injector.getInstance(Class<T>) is not supported in Stage.TOOL");
        }
    }
}

