/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.plotsquared.google.Guice;
import com.plotsquared.google.Key;
import com.plotsquared.google.MembersInjector;
import com.plotsquared.google.Provides;
import com.plotsquared.google.ProvisionException;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InternalFlags;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.internal.SourceFormatter;
import com.plotsquared.google.internal.util.SourceProvider;
import com.plotsquared.google.internal.util.StackTraceElements;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.InjectionListener;
import com.plotsquared.google.spi.Message;
import jakarta.inject.Provider;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InternalProvisionException
extends Exception {
    private static final Logger logger = Logger.getLogger(Guice.class.getName());
    private static final Set<Dependency<?>> warnedDependencies = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<Object> sourcesToPrepend = new ArrayList<Object>();
    private final ImmutableList<Message> errors;

    public static InternalProvisionException circularDependenciesDisabled(Class<?> clazz) {
        return InternalProvisionException.create(ErrorId.CIRCULAR_PROXY_DISABLED, "Found a circular dependency involving %s, and circular dependencies are disabled.", clazz);
    }

    public static InternalProvisionException cannotProxyClass(Class<?> clazz) {
        return InternalProvisionException.create(ErrorId.CAN_NOT_PROXY_CLASS, "Tried proxying %s to support a circular dependency, but it is not an interface.", clazz);
    }

    public static InternalProvisionException create(ErrorId errorId, String string, Object ... objectArray) {
        return new InternalProvisionException(Messages.create(errorId, string, objectArray));
    }

    public static InternalProvisionException errorInUserCode(ErrorId errorId, Throwable throwable, String string, Object ... objectArray) {
        Collection<Message> collection = Errors.getMessagesFromThrowable(throwable);
        if (!collection.isEmpty()) {
            return new InternalProvisionException(collection);
        }
        return new InternalProvisionException(Messages.create(errorId, throwable, string, objectArray));
    }

    public static InternalProvisionException subtypeNotProvided(Class<? extends Provider<?>> clazz, Class<?> clazz2) {
        return InternalProvisionException.create(ErrorId.SUBTYPE_NOT_PROVIDED, "%s doesn't provide instances of %s.", clazz, clazz2);
    }

    public static InternalProvisionException errorInProvider(Throwable throwable) {
        return InternalProvisionException.errorInUserCode(ErrorId.ERROR_IN_CUSTOM_PROVIDER, throwable, "%s", throwable);
    }

    public static InternalProvisionException errorInjectingMethod(Throwable throwable) {
        return InternalProvisionException.errorInUserCode(ErrorId.ERROR_INJECTING_METHOD, throwable, "%s", throwable);
    }

    public static InternalProvisionException errorInjectingConstructor(Throwable throwable) {
        return InternalProvisionException.errorInUserCode(ErrorId.ERROR_INJECTING_CONSTRUCTOR, throwable, "%s", throwable);
    }

    public static InternalProvisionException errorInUserInjector(MembersInjector<?> membersInjector, TypeLiteral<?> typeLiteral, RuntimeException runtimeException) {
        return InternalProvisionException.errorInUserCode(ErrorId.ERROR_IN_USER_INJECTOR, runtimeException, "Error injecting %s using %s.\n Reason: %s", typeLiteral, membersInjector, runtimeException);
    }

    public static InternalProvisionException jitDisabled(Key<?> key) {
        return InternalProvisionException.create(ErrorId.JIT_DISABLED, "Explicit bindings are required and %s is not explicitly bound.", key);
    }

    public static InternalProvisionException errorNotifyingInjectionListener(InjectionListener<?> injectionListener, TypeLiteral<?> typeLiteral, RuntimeException runtimeException) {
        return InternalProvisionException.errorInUserCode(ErrorId.OTHER, runtimeException, "Error notifying InjectionListener %s of %s.\n Reason: %s", injectionListener, typeLiteral, runtimeException);
    }

    static void onNullInjectedIntoNonNullableDependency(Object object, Dependency<?> dependency) {
        Object object2;
        if (dependency.getInjectionPoint().getMember() instanceof Method && ((AccessibleObject)(object2 = (Method)dependency.getInjectionPoint().getMember())).isAnnotationPresent(Provides.class)) {
            switch (InternalFlags.getNullableProvidesOption()) {
                case ERROR: {
                    break;
                }
                case IGNORE: {
                    return;
                }
                case WARN: {
                    if (warnedDependencies.add(dependency)) {
                        logger.log(Level.WARNING, "Guice injected null into {0} (a {1}), please mark it @Nullable. Use -Dguice_check_nullable_provides_params=ERROR to turn this into an error.", new Object[]{SourceFormatter.getParameterName(dependency), Messages.convert(dependency.getKey())});
                    }
                    return;
                }
            }
        }
        object2 = dependency.getParameterIndex() != -1 ? SourceFormatter.getParameterName(dependency) : "";
        Object object3 = StackTraceElements.forMember(dependency.getInjectionPoint().getMember());
        Object object4 = ((String)object2).isEmpty() ? object3 : "the " + (String)object2 + " of " + object3;
        throw InternalProvisionException.create(ErrorId.NULL_INJECTED_INTO_NON_NULLABLE, "null returned by binding at %s\n but %s is not @Nullable", object, object4).addSource(object);
    }

    InternalProvisionException(Message message) {
        this((Iterable<Message>)ImmutableList.of((Object)message));
    }

    private InternalProvisionException(Iterable<Message> iterable) {
        this.errors = ImmutableList.copyOf(iterable);
        Preconditions.checkArgument((!this.errors.isEmpty() ? 1 : 0) != 0, (Object)"Can't create a provision exception with no errors");
    }

    InternalProvisionException addSource(Object object) {
        if (object == SourceProvider.UNKNOWN_SOURCE) {
            return this;
        }
        int n = this.sourcesToPrepend.size();
        if (n > 0 && this.sourcesToPrepend.get(n - 1) == object) {
            return this;
        }
        this.sourcesToPrepend.add(object);
        return this;
    }

    ImmutableList<Message> getErrors() {
        ImmutableList.Builder builder = ImmutableList.builder();
        List list = Lists.reverse(this.sourcesToPrepend);
        for (Message message : this.errors) {
            builder.add((Object)Messages.mergeSources(list, message));
        }
        return builder.build();
    }

    public ProvisionException toProvisionException() {
        ProvisionException provisionException = new ProvisionException((Iterable<Message>)this.getErrors());
        return provisionException;
    }
}

