/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.plotsquared.core.aopalliance.intercept.MethodInterceptor;
import com.plotsquared.google.matcher.Matcher;
import com.plotsquared.google.spi.InterceptorBinding;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

final class MethodAspect {
    private final Matcher<? super Class<?>> classMatcher;
    private final Matcher<? super Method> methodMatcher;
    private final List<MethodInterceptor> interceptors;

    static MethodAspect fromBinding(InterceptorBinding interceptorBinding) {
        return new MethodAspect(interceptorBinding.getClassMatcher(), interceptorBinding.getMethodMatcher(), interceptorBinding.getInterceptors());
    }

    MethodAspect(Matcher<? super Class<?>> matcher, Matcher<? super Method> matcher2, List<MethodInterceptor> list) {
        this.classMatcher = (Matcher)Preconditions.checkNotNull(matcher, (Object)"class matcher");
        this.methodMatcher = (Matcher)Preconditions.checkNotNull(matcher2, (Object)"method matcher");
        this.interceptors = (List)Preconditions.checkNotNull(list, (Object)"interceptors");
    }

    MethodAspect(Matcher<? super Class<?>> matcher, Matcher<? super Method> matcher2, MethodInterceptor ... methodInterceptorArray) {
        this(matcher, matcher2, Arrays.asList(methodInterceptorArray));
    }

    boolean matches(Class<?> clazz) {
        return this.classMatcher.matches(clazz);
    }

    boolean matches(Method method) {
        return this.methodMatcher.matches(method);
    }

    List<MethodInterceptor> interceptors() {
        return this.interceptors;
    }
}

