/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.Key;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.util.Types;
import jakarta.inject.Provider;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class MoreTypes {
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private static final ImmutableMap<TypeLiteral<?>, TypeLiteral<?>> PRIMITIVE_TO_WRAPPER = new ImmutableMap.Builder().put(TypeLiteral.get(Boolean.TYPE), TypeLiteral.get(Boolean.class)).put(TypeLiteral.get(Byte.TYPE), TypeLiteral.get(Byte.class)).put(TypeLiteral.get(Short.TYPE), TypeLiteral.get(Short.class)).put(TypeLiteral.get(Integer.TYPE), TypeLiteral.get(Integer.class)).put(TypeLiteral.get(Long.TYPE), TypeLiteral.get(Long.class)).put(TypeLiteral.get(Float.TYPE), TypeLiteral.get(Float.class)).put(TypeLiteral.get(Double.TYPE), TypeLiteral.get(Double.class)).put(TypeLiteral.get(Character.TYPE), TypeLiteral.get(Character.class)).put(TypeLiteral.get(Void.TYPE), TypeLiteral.get(Void.class)).buildOrThrow();

    private MoreTypes() {
    }

    public static <T> Key<T> canonicalizeKey(Key<T> key) {
        if (key.getClass() == Key.class) {
            return key;
        }
        return key.ofType(key.getTypeLiteral());
    }

    public static <T> TypeLiteral<T> canonicalizeForKey(TypeLiteral<T> typeLiteral) {
        Type type = typeLiteral.getType();
        if (!MoreTypes.isFullySpecified(type)) {
            Errors errors = new Errors().keyNotFullySpecified(typeLiteral);
            throw new ConfigurationException(errors.getMessages());
        }
        if (typeLiteral.getRawType() == Provider.class) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            TypeLiteral<?> typeLiteral2 = TypeLiteral.get(Types.providerOf(MoreTypes.getSharedTypeArguments(parameterizedType)[0]));
            return typeLiteral2;
        }
        TypeLiteral typeLiteral3 = (TypeLiteral)PRIMITIVE_TO_WRAPPER.get(typeLiteral);
        if (typeLiteral3 != null) {
            return typeLiteral3;
        }
        if (typeLiteral.getClass() == TypeLiteral.class) {
            return typeLiteral;
        }
        TypeLiteral<?> typeLiteral4 = TypeLiteral.get(typeLiteral.getType());
        return typeLiteral4;
    }

    private static boolean isFullySpecified(Type type) {
        if (type instanceof Class) {
            return true;
        }
        if (type instanceof CompositeType) {
            return ((CompositeType)((Object)type)).isFullySpecified();
        }
        if (type instanceof TypeVariable) {
            return false;
        }
        return ((CompositeType)((Object)MoreTypes.canonicalize(type))).isFullySpecified();
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() ? new GenericArrayTypeImpl(MoreTypes.canonicalize(clazz.getComponentType())) : clazz;
        }
        if (type instanceof CompositeType) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new ParameterizedTypeImpl(parameterizedType.getOwnerType(), parameterizedType.getRawType(), MoreTypes.getSharedTypeArguments(parameterizedType));
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return new GenericArrayTypeImpl(genericArrayType.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new WildcardTypeImpl(wildcardType.getUpperBounds(), wildcardType.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            Preconditions.checkArgument((boolean)(type2 instanceof Class), (String)"Expected a Class, but <%s> is of type %s", (Object)type, (Object)type.getClass().getName());
            return (Class)type2;
        }
        if (type instanceof GenericArrayType) {
            Type type3 = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(MoreTypes.getRawType(type3), 0).getClass();
        }
        if (type instanceof TypeVariable || type instanceof WildcardType) {
            return Object.class;
        }
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + type.getClass().getName());
    }

    public static boolean equals(Type type, Type type2) {
        if (type == type2) {
            return true;
        }
        if (type instanceof Class) {
            return type.equals(type2);
        }
        if (type instanceof ParameterizedType) {
            if (!(type2 instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ParameterizedType parameterizedType2 = (ParameterizedType)type2;
            return Objects.equal((Object)parameterizedType.getOwnerType(), (Object)parameterizedType2.getOwnerType()) && parameterizedType.getRawType().equals(parameterizedType2.getRawType()) && Arrays.equals(MoreTypes.getSharedTypeArguments(parameterizedType), MoreTypes.getSharedTypeArguments(parameterizedType2));
        }
        if (type instanceof GenericArrayType) {
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType genericArrayType = (GenericArrayType)type;
            GenericArrayType genericArrayType2 = (GenericArrayType)type2;
            return MoreTypes.equals(genericArrayType.getGenericComponentType(), genericArrayType2.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            if (!(type2 instanceof WildcardType)) {
                return false;
            }
            WildcardType wildcardType = (WildcardType)type;
            WildcardType wildcardType2 = (WildcardType)type2;
            return Arrays.equals(wildcardType.getUpperBounds(), wildcardType2.getUpperBounds()) && Arrays.equals(wildcardType.getLowerBounds(), wildcardType2.getLowerBounds());
        }
        if (type instanceof TypeVariable) {
            if (!(type2 instanceof TypeVariable)) {
                return false;
            }
            TypeVariable typeVariable = (TypeVariable)type;
            TypeVariable typeVariable2 = (TypeVariable)type2;
            return typeVariable.getGenericDeclaration().equals(typeVariable2.getGenericDeclaration()) && typeVariable.getName().equals(typeVariable2.getName());
        }
        return false;
    }

    private static int hashCodeOrZero(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static String typeToString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    public static Type getGenericSupertype(Type type, Class<?> object, Class<?> clazz) {
        Object object2;
        if (clazz == object) {
            return type;
        }
        if (clazz.isInterface()) {
            object2 = ((Class)object).getInterfaces();
            int n = ((Class<?>[])object2).length;
            for (int i = 0; i < n; ++i) {
                if (object2[i] == clazz) {
                    return ((Class)object).getGenericInterfaces()[i];
                }
                if (!clazz.isAssignableFrom(object2[i])) continue;
                return MoreTypes.getGenericSupertype(((Class)object).getGenericInterfaces()[i], object2[i], clazz);
            }
        }
        if (!((Class)object).isInterface()) {
            while (object != Object.class) {
                object2 = ((Class)object).getSuperclass();
                if (object2 == clazz) {
                    return ((Class)object).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object2)) {
                    return MoreTypes.getGenericSupertype(((Class)object).getGenericSuperclass(), object2, clazz);
                }
                object = object2;
            }
        }
        return clazz;
    }

    public static Type resolveTypeVariable(Type type, Class<?> clazz, TypeVariable<?> typeVariable) {
        Class<?> clazz2 = MoreTypes.declaringClassOf(typeVariable);
        if (clazz2 == null) {
            return typeVariable;
        }
        Type type2 = MoreTypes.getGenericSupertype(type, clazz, clazz2);
        if (type2 instanceof ParameterizedType) {
            int n = MoreTypes.indexOf(clazz2.getTypeParameters(), typeVariable);
            return MoreTypes.getSharedTypeArguments((ParameterizedType)type2)[n];
        }
        return typeVariable;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Type[] getSharedTypeArguments(ParameterizedType parameterizedType) {
        if (parameterizedType instanceof ParameterizedTypeImpl) {
            return ((ParameterizedTypeImpl)parameterizedType).typeArguments;
        }
        return parameterizedType.getActualTypeArguments();
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object obj = typeVariable.getGenericDeclaration();
        return obj instanceof Class ? (Class)obj : null;
    }

    private static void checkNotPrimitive(Type type, String string) {
        Preconditions.checkArgument((!(type instanceof Class) || !((Class)type).isPrimitive() ? 1 : 0) != 0, (String)"Primitive types are not allowed in %s: %s", (Object)string, (Object)type);
    }

    private static interface CompositeType {
        public boolean isFullySpecified();
    }

    public static class WildcardTypeImpl
    implements WildcardType,
    Serializable,
    CompositeType {
        private final Type upperBound;
        private final Type lowerBound;
        private static final long serialVersionUID = 0L;

        public WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            Preconditions.checkArgument((typeArray2.length <= 1 ? 1 : 0) != 0, (Object)"Must have at most one lower bound.");
            Preconditions.checkArgument((typeArray.length == 1 ? 1 : 0) != 0, (Object)"Must have exactly one upper bound.");
            if (typeArray2.length == 1) {
                Preconditions.checkNotNull((Object)typeArray2[0], (Object)"lowerBound");
                MoreTypes.checkNotPrimitive(typeArray2[0], "wildcard bounds");
                Preconditions.checkArgument((typeArray[0] == Object.class ? 1 : 0) != 0, (Object)"bounded both ways");
                this.lowerBound = MoreTypes.canonicalize(typeArray2[0]);
                this.upperBound = Object.class;
            } else {
                Preconditions.checkNotNull((Object)typeArray[0], (Object)"upperBound");
                MoreTypes.checkNotPrimitive(typeArray[0], "wildcard bounds");
                this.lowerBound = null;
                this.upperBound = MoreTypes.canonicalize(typeArray[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        @Override
        public boolean isFullySpecified() {
            return MoreTypes.isFullySpecified(this.upperBound) && (this.lowerBound == null || MoreTypes.isFullySpecified(this.lowerBound));
        }

        public boolean equals(Object object) {
            return object instanceof WildcardType && MoreTypes.equals(this, (WildcardType)object);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + MoreTypes.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + MoreTypes.typeToString(this.upperBound);
        }
    }

    public static class GenericArrayTypeImpl
    implements GenericArrayType,
    Serializable,
    CompositeType {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        public GenericArrayTypeImpl(Type type) {
            this.componentType = MoreTypes.canonicalize(type);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        @Override
        public boolean isFullySpecified() {
            return MoreTypes.isFullySpecified(this.componentType);
        }

        public boolean equals(Object object) {
            return object instanceof GenericArrayType && MoreTypes.equals(this, (GenericArrayType)object);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return MoreTypes.typeToString(this.componentType) + "[]";
        }
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType,
    Serializable,
    CompositeType {
        private final Type ownerType;
        private final Type rawType;
        final Type[] typeArguments;
        private static final long serialVersionUID = 0L;

        public ParameterizedTypeImpl(Type type, Type type2, Type ... typeArray) {
            ParameterizedTypeImpl.ensureOwnerType(type, type2);
            this.ownerType = type == null ? null : MoreTypes.canonicalize(type);
            this.rawType = MoreTypes.canonicalize(type2);
            int n = typeArray.length;
            Type[] typeArray2 = (Type[])typeArray.clone();
            int n2 = n;
            if (this.rawType instanceof Class) {
                Class clazz = (Class)this.rawType;
                int n3 = clazz.getTypeParameters().length;
                if (n < n3) {
                    throw new IllegalArgumentException("Length of provided type arguments is less than length of required parameters for class:" + clazz.getName() + " provided type argument length:" + n + " length of class parameters:" + n3);
                }
                if (n > n3) {
                    n2 = n3;
                }
            }
            this.typeArguments = new Type[n2];
            for (int i = 0; i < n2; ++i) {
                Preconditions.checkNotNull((Object)typeArray2[i], (Object)"type parameter");
                MoreTypes.checkNotPrimitive(typeArray2[i], "type parameters");
                this.typeArguments[i] = MoreTypes.canonicalize(typeArray2[i]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public boolean isFullySpecified() {
            if (this.ownerType != null && !MoreTypes.isFullySpecified(this.ownerType)) {
                return false;
            }
            if (!MoreTypes.isFullySpecified(this.rawType)) {
                return false;
            }
            for (Type type : this.typeArguments) {
                if (MoreTypes.isFullySpecified(type)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof ParameterizedType && MoreTypes.equals(this, (ParameterizedType)object);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ MoreTypes.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(30 * (this.typeArguments.length + 1));
            stringBuilder.append(MoreTypes.typeToString(this.rawType));
            if (this.typeArguments.length == 0) {
                return stringBuilder.toString();
            }
            stringBuilder.append('<').append(MoreTypes.typeToString(this.typeArguments[0]));
            for (int i = 1; i < this.typeArguments.length; ++i) {
                stringBuilder.append(", ").append(MoreTypes.typeToString(this.typeArguments[i]));
            }
            return stringBuilder.append('>').toString();
        }

        private static void ensureOwnerType(Type type, Type type2) {
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                Preconditions.checkArgument((type != null || clazz.getEnclosingClass() == null ? 1 : 0) != 0, (String)"No owner type for enclosed %s", (Object)type2);
                Preconditions.checkArgument((type == null || clazz.getEnclosingClass() != null ? 1 : 0) != 0, (String)"Owner type for unenclosed %s", (Object)type2);
            }
        }
    }
}

