/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.plotsquared.google.internal.Messages;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class PackageNameCompressor {
    static final String LEGEND_HEADER = "\n\n======================\nFull classname legend:\n======================\n";
    static final String LEGEND_FOOTER = "========================\nEnd of classname legend:\n========================\n";
    private static final ImmutableSet<String> PACKAGES_SKIPPED_IN_LEGEND = ImmutableSet.of((Object)"java.lang.", (Object)"java.util.");
    private static final Splitter PACKAGE_SPLITTER = Splitter.on((char)'.');
    private static final Joiner PACKAGE_JOINER = Joiner.on((char)'.');
    private static final Pattern CLASSNAME_PATTERN = Pattern.compile("[\\W](([a-z_0-9]++[.]){2,}+[A-Z][\\w$]*)");
    private static final Pattern QUOTED_PATTERN = Pattern.compile("([^\\\"]+)((\\\")?[^\\\"\\r\\n]*\\\")?");

    static String compressPackagesInMessage(String string) {
        Map<String, String> map;
        Matcher matcher = CLASSNAME_PATTERN.matcher(string);
        HashSet<String> hashSet = new HashSet<String>();
        while (matcher.find()) {
            map = matcher.group(1);
            hashSet.add((String)((Object)map));
        }
        map = PackageNameCompressor.shortenNames(hashSet);
        if (map.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ImmutableSet<String> immutableSet = PackageNameCompressor.replaceFullNames(string, map, stringBuilder);
        if (immutableSet.isEmpty()) {
            return string;
        }
        String string2 = PackageNameCompressor.buildClassNameLegend(Maps.filterKeys((Map)map, arg_0 -> immutableSet.contains(arg_0)));
        return stringBuilder.append(string2).toString();
    }

    private static ImmutableSet<String> replaceFullNames(String string, Map<String, String> map, StringBuilder stringBuilder) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        List list = map.keySet().stream().sorted(Ordering.natural().reverse()).collect(Collectors.toList());
        Matcher matcher = QUOTED_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            for (String string3 : list) {
                String string4 = map.get(string3);
                int n = string2.length();
                if ((string2 = string2.replace(string4, string3)).length() >= n) continue;
                builder.add((Object)string3);
            }
            stringBuilder.append(string2);
            String string5 = matcher.group(2);
            if (string5 == null) continue;
            stringBuilder.append(string5);
        }
        return builder.build();
    }

    private static String buildClassNameLegend(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = map.keySet().stream().max(Comparator.comparing(String::length)).get().length();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String string3 = string2.substring(0, string2.length() - string.length());
            if (PACKAGES_SKIPPED_IN_LEGEND.contains((Object)string3) && !string.contains(".")) continue;
            stringBuilder.append(string).append(": ").append(Strings.repeat((String)" ", (int)(n - string.length()))).append('\"').append(string2).append('\"').append("\n");
        }
        return stringBuilder.length() == 0 ? "" : Messages.bold(LEGEND_HEADER) + Messages.faint(stringBuilder.toString()) + Messages.bold(LEGEND_FOOTER);
    }

    /*
     * Exception decompiling
     */
    private static Map<String, String> shortenNames(Collection<String> var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[DOLOOP]], but top level block is 4[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PackageNameCompressor() {
    }
}

