/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.Stage;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.spi.ProvisionListenerBinding;
import java.util.List;
import java.util.logging.Logger;

final class ProvisionListenerCallbackStore {
    private static final ImmutableSet<Key<?>> INTERNAL_BINDINGS = ImmutableSet.of(Key.get(Injector.class), Key.get(Stage.class), Key.get(Logger.class));
    private final ImmutableList<ProvisionListenerBinding> listenerBindings;
    private final LoadingCache<KeyBinding, ProvisionListenerStackCallback<?>> cache = CacheBuilder.newBuilder().build(new CacheLoader<KeyBinding, ProvisionListenerStackCallback<?>>(){

        public ProvisionListenerStackCallback<?> load(KeyBinding keyBinding) {
            return ProvisionListenerCallbackStore.this.create(keyBinding.binding);
        }
    });

    ProvisionListenerCallbackStore(List<ProvisionListenerBinding> list) {
        this.listenerBindings = ImmutableList.copyOf(list);
    }

    public <T> ProvisionListenerStackCallback<T> get(Binding<T> binding) {
        if (!INTERNAL_BINDINGS.contains(binding.getKey())) {
            ProvisionListenerStackCallback provisionListenerStackCallback = (ProvisionListenerStackCallback)this.cache.getUnchecked((Object)new KeyBinding(binding.getKey(), binding));
            return provisionListenerStackCallback.hasListeners() ? provisionListenerStackCallback : null;
        }
        return null;
    }

    boolean remove(Binding<?> binding) {
        return this.cache.asMap().remove(binding) != null;
    }

    private <T> ProvisionListenerStackCallback<T> create(Binding<T> binding) {
        List list = null;
        for (ProvisionListenerBinding provisionListenerBinding : this.listenerBindings) {
            if (!provisionListenerBinding.getBindingMatcher().matches(binding)) continue;
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.addAll(provisionListenerBinding.getListeners());
        }
        if (list == null || list.isEmpty()) {
            return ProvisionListenerStackCallback.emptyListener();
        }
        return new ProvisionListenerStackCallback<T>(binding, list);
    }

    private static class KeyBinding {
        final Key<?> key;
        final Binding<?> binding;

        KeyBinding(Key<?> key, Binding<?> binding) {
            this.key = key;
            this.binding = binding;
        }

        public boolean equals(Object object) {
            return object instanceof KeyBinding && this.key.equals(((KeyBinding)object).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

