/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.plotsquared.google.Scope;
import com.plotsquared.google.internal.AbstractProcessor;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.spi.ScopeBinding;

final class ScopeBindingProcessor
extends AbstractProcessor {
    ScopeBindingProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(ScopeBinding scopeBinding) {
        ScopeBinding scopeBinding2;
        Scope scope = (Scope)Preconditions.checkNotNull((Object)scopeBinding.getScope(), (Object)"scope");
        Class clazz = (Class)Preconditions.checkNotNull(scopeBinding.getAnnotationType(), (Object)"annotation type");
        if (!Annotations.isScopeAnnotation(clazz)) {
            this.errors.missingScopeAnnotation(clazz);
        }
        if (!Annotations.isRetainedAtRuntime(clazz)) {
            this.errors.missingRuntimeRetention(clazz);
        }
        if ((scopeBinding2 = this.injector.getBindingData().getScopeBinding(clazz)) != null) {
            if (!scope.equals(scopeBinding2.getScope())) {
                this.errors.duplicateScopes(scopeBinding2, clazz, scope);
            }
        } else {
            this.injector.getBindingData().putScopeBinding(clazz, scopeBinding);
        }
        return true;
    }
}

