/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.Lists;
import com.plotsquared.google.internal.ErrorFormatter;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.InternalErrorDetail;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.spi.ErrorDetail;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

final class ScopeNotFoundError
extends InternalErrorDetail<ScopeNotFoundError> {
    private final Class<? extends Annotation> scopeAnnotation;

    ScopeNotFoundError(Class<? extends Annotation> clazz, List<Object> list) {
        super(ErrorId.SCOPE_NOT_FOUND, String.format("No scope is bound to %s.", Messages.convert(clazz)), list, null);
        this.scopeAnnotation = clazz;
    }

    @Override
    public boolean isMergeable(ErrorDetail<?> errorDetail) {
        return errorDetail instanceof ScopeNotFoundError && ((ScopeNotFoundError)errorDetail).scopeAnnotation.equals(this.scopeAnnotation);
    }

    @Override
    protected void formatDetail(List<ErrorDetail<?>> list, Formatter formatter) {
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        arrayList.add(this.getSources());
        list.stream().map(ErrorDetail::getSources).forEach(arrayList::add);
        formatter.format("\n%s\n", "Used at:");
        int n = 1;
        for (List list2 : arrayList) {
            ErrorFormatter.formatSources(n++, Lists.reverse((List)list2), formatter);
        }
    }

    @Override
    public ScopeNotFoundError withSources(List<Object> list) {
        return new ScopeNotFoundError(this.scopeAnnotation, list);
    }
}

