/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.internal.BytecodeGen;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFlags;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.SingleMemberInjector;
import com.plotsquared.google.internal.SingleParameterInjector;
import com.plotsquared.google.spi.InjectionPoint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiFunction;

final class SingleMethodInjector
implements SingleMemberInjector {
    private final InjectorImpl.MethodInvoker methodInvoker;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final InjectionPoint injectionPoint;

    SingleMethodInjector(InjectorImpl injectorImpl, InjectionPoint injectionPoint, Errors errors) {
        this.injectionPoint = injectionPoint;
        Method method = (Method)injectionPoint.getMember();
        this.methodInvoker = this.createMethodInvoker(method);
        this.parameterInjectors = injectorImpl.getParametersInjectors(injectionPoint.getDependencies(), errors);
    }

    private InjectorImpl.MethodInvoker createMethodInvoker(final Method method) {
        int n;
        if (InternalFlags.isBytecodeGenEnabled()) {
            try {
                final BiFunction<Object, Object[], Object> biFunction = BytecodeGen.fastMethod(method);
                if (biFunction != null) {
                    return new InjectorImpl.MethodInvoker(this){

                        @Override
                        public Object invoke(Object object, Object ... objectArray) {
                            try {
                                return biFunction.apply(object, objectArray);
                            }
                            catch (Throwable throwable) {
                                throw new InvocationTargetException(throwable);
                            }
                        }
                    };
                }
            }
            catch (Exception | LinkageError throwable) {
                // empty catch block
            }
        }
        if (!Modifier.isPublic(n = method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
        return new InjectorImpl.MethodInvoker(this){

            @Override
            public Object invoke(Object object, Object ... objectArray) {
                return method.invoke(object, objectArray);
            }
        };
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(InternalContext internalContext, Object object) {
        Object[] objectArray = SingleParameterInjector.getAll(internalContext, this.parameterInjectors);
        try {
            this.methodInvoker.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause() != null ? invocationTargetException.getCause() : invocationTargetException;
            throw InternalProvisionException.errorInjectingMethod(throwable).addSource(this.injectionPoint);
        }
    }
}

