/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.plotsquared.google.Key;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.internal.util.Classes;
import com.plotsquared.google.internal.util.StackTraceElements;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.ElementSource;
import com.plotsquared.google.spi.InjectionPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

final class SourceFormatter {
    static final String INDENT = Strings.repeat((String)" ", (int)5);
    private final Object source;
    private final Formatter formatter;
    private final boolean omitPreposition;
    private final String moduleStack;

    SourceFormatter(Object object, Formatter formatter, boolean bl) {
        if (object instanceof ElementSource) {
            ElementSource elementSource = (ElementSource)object;
            this.source = elementSource.getDeclaringSource();
            this.moduleStack = SourceFormatter.getModuleStack(elementSource);
        } else {
            this.source = object;
            this.moduleStack = "";
        }
        this.formatter = formatter;
        this.omitPreposition = bl;
    }

    void format() {
        boolean bl;
        boolean bl2 = bl = !this.moduleStack.isEmpty();
        if (this.source instanceof Dependency) {
            this.formatDependency((Dependency)this.source);
        } else if (this.source instanceof InjectionPoint) {
            this.formatInjectionPoint(null, (InjectionPoint)this.source);
        } else if (this.source instanceof Class) {
            this.formatter.format("%s%s\n", this.preposition("at "), StackTraceElements.forType((Class)this.source));
        } else if (this.source instanceof Member) {
            this.formatMember((Member)this.source);
        } else if (this.source instanceof TypeLiteral) {
            this.formatter.format("%s%s\n", this.preposition("while locating "), this.source);
        } else if (this.source instanceof Key) {
            this.formatKey((Key)this.source);
        } else if (this.source instanceof Thread) {
            bl = false;
            this.formatter.format("%s%s\n", this.preposition("in thread "), this.source);
        } else {
            this.formatter.format("%s%s\n", this.preposition("at "), this.source);
        }
        if (bl) {
            this.formatter.format("%s \\_ installed by: %s\n", INDENT, this.moduleStack);
        }
    }

    private String preposition(String string) {
        if (this.omitPreposition) {
            return "";
        }
        return string;
    }

    private void formatDependency(Dependency<?> dependency) {
        InjectionPoint injectionPoint = dependency.getInjectionPoint();
        if (injectionPoint != null) {
            this.formatInjectionPoint(dependency, injectionPoint);
        } else {
            this.formatKey(dependency.getKey());
        }
    }

    private void formatKey(Key<?> key) {
        this.formatter.format("%s%s\n", this.preposition("while locating "), Messages.convert(key));
    }

    private void formatMember(Member member) {
        this.formatter.format("%s%s\n", this.preposition("at "), StackTraceElements.forMember(member));
    }

    private void formatInjectionPoint(Dependency<?> dependency, InjectionPoint injectionPoint) {
        Member member = injectionPoint.getMember();
        Class<? extends Member> clazz = Classes.memberType(member);
        this.formatMember(injectionPoint.getMember());
        if (clazz == Field.class) {
            this.formatter.format("%s \\_ for field %s\n", INDENT, Messages.redBold(member.getName()));
        } else if (dependency != null) {
            this.formatter.format("%s \\_ for %s\n", INDENT, SourceFormatter.getParameterName(dependency));
        }
    }

    static String getModuleStack(ElementSource elementSource) {
        if (elementSource == null) {
            return "";
        }
        ArrayList arrayList = Lists.newArrayList(elementSource.getModuleClassNames());
        while (elementSource.getOriginalElementSource() != null) {
            elementSource = elementSource.getOriginalElementSource();
            arrayList.addAll(0, elementSource.getModuleClassNames());
        }
        if (arrayList.size() <= 1) {
            return "";
        }
        return String.join((CharSequence)" -> ", Lists.reverse((List)arrayList));
    }

    static String getParameterName(Dependency<?> dependency) {
        int n = dependency.getParameterIndex();
        int n2 = n + 1;
        Member member = dependency.getInjectionPoint().getMember();
        Parameter parameter = null;
        if (member instanceof Constructor) {
            parameter = ((Constructor)member).getParameters()[n];
        } else if (member instanceof Method) {
            parameter = ((Method)member).getParameters()[n];
        }
        String string = "";
        if (parameter != null && parameter.isNamePresent()) {
            string = parameter.getName();
        }
        return String.format("%s%s parameter%s", n2, SourceFormatter.getOrdinalSuffix(n2), string.isEmpty() ? "" : " " + Messages.redBold(string));
    }

    private static String getOrdinalSuffix(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
        if (n / 10 % 10 == 1) {
            return "th";
        }
        switch (n % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }
}

